/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.demo;

import com.arsdigita.bebop.BebopMapDispatcher;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.util.UncheckedWrapperException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;


/**
 * A dispatcher that looks for "buildPage*" methods, invokes them,
 * and constructs an index page with links automatically.
 *
 * */
public class AutoDispatcher extends BebopMapDispatcher {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/AutoDispatcher.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log =
        Logger.getLogger(AutoDispatcher.class);

    public AutoDispatcher() {
        setUp();                // set up map & index
    }

    /** Set up map by reflection and index page.
     *  For use from derived classes; 'this' indicates where builPage_* are.
     */
    protected void setUp()
    {
        setUp(this);
    }

    /**
     * The constructor Instantiates the subsite url->page mapping.
     * Unlike a typical Dispatcher constrctor, this one invokes any
     * method starting in "buildPage" in the class of the child and puts the
     * returned page in the map.  Also creates an index page with
     * links to all pages in the map.  This makes adding another page
     * as easy as writing its build method; the rest is automated.  */
    public void setUp(Object child) {
        Map m = new TreeMap();

        final String prefix = "buildPage";
        Method method[] = child.getClass().getDeclaredMethods();
        for (int i = 0; i < method.length; i++) {
            String name = method[i].getName();
            if (name.startsWith(prefix)) {
                try {
                    m.put(name.substring(prefix.length()),
                          method[i].invoke(null, new Object[0]));
                } catch (Exception ex) {
                    throw new UncheckedWrapperException(name, ex);
                }
            }
        }

        // pages added above will show up in the index
        Page index = buildIndexPage(m.entrySet().iterator(),
                                    "Index for " + child.getClass().getName());
        m.put("", index);
        m.put("index", index);
        // any pages added below won't be listed.

        setMap(m);
    }

    /**
     * @return a Bebop page for the index
     */
    private static Page buildIndexPage(Iterator entries, String title) {
        Page p = new Page(title);
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry) entries.next();
            p.add(
                  new Link(
                           ((Page) entry.getValue()).getTitle(),
                           (String) entry.getKey()
                           )
                  );
        }

        p.lock();
        return p;
    }
}
