/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.PageState;

/**
 *
 * Interface that should be implemented by components that have
 * state parameters that need to be reset when the component is shown
 * to the user. The details of when the reset method is called are left
 * to the application programmer.
 *
 */
public interface Resettable {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/Resettable.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     * Resets the state of the component to its original
     * appearance.
     *
     * @param state the page state
     */
    void reset(PageState state);
}
