/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

/**
 *  A model builder for
 * the {@link Paginator} component.
 *
 * <p>The {@link #getTotalSize(Paginator, PageState)} method of this
 * class is called during the generation of page links for a
 * <code>Paginator</code> component. When using a
 * <code>Paginator</code> component with a {@link List} or a {@link
 * Table}, you can achieve greater flexibility in terms of caching and
 * performance by having the model builder implement this interface.
 *
 * <p>Unlike other model builder classes in Bebop, there is no
 * PaginationModel class, as this would only be an <code>int</code>.
 *
 * @see Paginator
 *
 * @author Phong Nguyen 
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/PaginationModelBuilder.java#8 $
 * @since 4.6.10
 **/
public interface PaginationModelBuilder {

    // $Change: 42026 $
    // $Revision: #8 $
    // $DateTime: 2004/04/07 16:07:11 $
    // $Author: dennis $

    /**
     * Returns the total number of results to paginate.
     *
     * @param paginator the Paginator instance that invoked this method
     * @param state the current page state
     * @return the total number of results to paginate.
     **/
    int getTotalSize(Paginator paginator, PageState state);

    /**
     * Determines whether the paginator should be visible in the request
     * represented by <code>state</code>.
     * This should normally delegate to the isVisible method of the
     * associated displayed component.
     *
     * @return <code>true</code> if the paginator is visible in the request;
     * <code>false</code> otherwise.
     *
     * @param state represents the current request
     * @return <code>true</code> if the component is visible; <code>false</code>
     * otherwise.
     * @pre state  != null
     */
    boolean isVisible(PageState state);

}
