/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.xml.Element;

import java.util.Iterator;


/**
 * Delimited dimensional navbar.
 *
 * @author Michael Pih 
 * @version $Revision: #8 $ $Date: 2004/04/07 $
 */
public class DimensionalNavbar extends SimpleContainer {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/DimensionalNavbar.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final static String BEBOP_XML_NS = "http://www.arsdigita.com/bebop/1.0";

    public final static String LEFT   = "left";
    public final static String RIGHT  = "right";
    public final static String CENTER = "center";

    private String m_startTag;
    private String m_endTag;
    private String m_delimiter;
    private String m_align;

    public DimensionalNavbar() {
        super();
        setAlign(RIGHT);
    }

    public void setStartTag(String s) {
        m_startTag = s;
    }

    public void setEndTag(String s) {
        m_endTag = s;
    }

    public void setDelimiter(String s) {
        m_delimiter = s;
    }

    public void setAlign(String s) {
        if ( s.equals(LEFT) || s.equals(RIGHT) || s.equals(CENTER) ) {
            m_align = s;
        } else {
            throw new IllegalArgumentException
                ("Align must be DimensionalNavbar.RIGHT, " +
                 "DimensionalNavbar.LEFT, or DimensionalNavbar.CENTER");
        }
    }


    public void generateXML(PageState state, Element parent) {

        Element navbar = parent.newChildElement("bebop:dimensionalNavbar",
                                                BEBOP_XML_NS);
        navbar.addAttribute("startTag", m_startTag);
        navbar.addAttribute("endTag", m_endTag);
        navbar.addAttribute("delimiter", m_delimiter);
        navbar.addAttribute("align", m_align);
        exportAttributes(navbar);

        Iterator children = children();
        Component child;
        while ( children.hasNext() ) {
            child = (Component) children.next();

            child.generateXML(state, navbar);
        }
    }
}
