/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;


import com.arsdigita.bebop.parameters.ParameterModel;

public class DefaultSingleSelectionModel
    extends AbstractSingleSelectionModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/DefaultSingleSelectionModel.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private RequestLocal m_key;

    public DefaultSingleSelectionModel() {
        super();
        m_key = new RequestLocal();
    }

    public Object getSelectedKey(PageState state) {
        return m_key.get(state);
    }

    public ParameterModel getStateParameter() {
        return null;
    }

    public void setSelectedKey(PageState state, Object key) {
        if ( key == null ) {
            if ( getSelectedKey(state) != null ) {
                m_key.set(state, null);
                fireStateChanged(state);
            }
        } else if ( ! key.equals(getSelectedKey(state)) ) {
            m_key.set(state, key);
            fireStateChanged(state);
        }
    }

}
