/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;



/**
 * Encapsulates the selection of a single object from many
 * possibilities. Similar to {@link SingleSelectionModel SingleSelectionModel},
 * but ties a component to the selection.
 *
 * <p> A call to the {@link #getComponent getComponent} method returns a
 * component that can be used to display the current selection.
 *
 * @author David Lutterkort 
 * @author Stanislav Freidin 
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/ComponentSelectionModel.java#7 $
 */
public interface ComponentSelectionModel extends SingleSelectionModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/ComponentSelectionModel.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";


    /**
     * Returns the component that should be used to output the currently
     * selected element.
     *
     * @param state the state of the current request
     * @return the component used to output the selected element.
     */
    Component getComponent(PageState state);

    /**
     * Return the selected object. The concrete type of the returned object
     * depends on the implementation of the model.
     *
     * @param state represents the state of the current request
     * @return the selected object
     */
    //Object getElement(PageState state);

    /**
     * Return an iterator over all the components that can possibly be used
     * in rendering selected objects. If one component may be used to render
     * various objects, for example for displaying detail information about
     * each of a number of objects of the same type, the component needs to
     * occur only once in the iterator.
     *
     * @return an iterator of components listing all the components that can
     * may be used in displaying selected objects
     */
    //Iterator components();

}
