/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.auditing;

/**
 * Factory for auditing save information.
 *  <p>
 *    
 *  </p>
 *
 * @author Joseph Bank 
 * @version 1.0
 */

public class AuditingSaveFactory {

    // default to using WebAuditingSaveInfo

    private static ThreadLocal s_proto = new ThreadLocal() {
            public Object initialValue() {
                return new WebAuditingSaveInfo();
            }
        };

    /**
     * Sets the prototype object for the factory.
     *
     * @param a prototype AuditingSaveInfo object
     */
    public static void setPrototype(AuditingSaveInfo proto) {
        s_proto.set(proto);
    }

    /**
     * Retrieves a new instance of an AuditingSaveInfo object
     * based on the prototype.
     *
     * @return a new AuditingSaveInfo object.
     */
    public static AuditingSaveInfo newInstance() {
        return ((AuditingSaveInfo) s_proto.get()).newInstance();
    }

}
