/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.auditing;

import com.arsdigita.kernel.User;
import java.util.Date;

/**
 * Interface for Audited objects.
 *  <p>
 *    
 *  </p>
 *
 * @author Joseph Bank
 * @version 1.0
 **/
public interface Audited {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/auditing/Audited.java#8 $";

    /**
     * Gets the user who created the object. May be null.
     * @return the user.
     */
    public User getCreationUser();

    /**
     * Gets the creation date of the object.
     * @return the object's creation date.
     */
    public Date getCreationDate();

    /**
     * Gets the creation IP address. May be null.
     * @return the creation IP address.

    */
    public String getCreationIP();

    /**
     * Gets the user who last modified the object. May be null.
     * @return the user who last modified the object.
     */
    public User getLastModifiedUser();

    /**
     * Gets the last modified date.
     * @return the date that the object was last modified.
     */
    public Date getLastModifiedDate();

    /**
     * Gets the last modified IP address. May be null.
     */
    public String getLastModifiedIP();
}
