/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.result;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import jd.io.Encoding;
import jd.util.Comparator;
import jd.util.Quicksort;
import jd.util.StringUtil;
import jd.util.TextBuffer;
import jd.xml.util.XmlWriter;
import jd.xml.xpath.model.NamespaceContext;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.result.NamespaceSupport;
import jd.xml.xslt.result.ResultBuilder;
import jd.xml.xslt.result.ResultLevel;

public class CanXmlResultBuilder
extends ResultBuilder {
    private NamespaceSupport nsSupport_;
    private boolean indent_;
    private boolean printedNonWhitespaceText_;
    private boolean beforeDocElement_;
    private TextBuffer textBuffer_;
    private TextBuffer textPartBuffer_;
    private NamespaceSupport.Declaration[] nsDeclarations_;
    private Attribute[] attributes_;
    private int attributeCount_;
    private boolean elementStarted_;
    private XmlLevel level_;
    private XsltResult result_;
    private XmlWriter out_;
    private static final AttributeComparator ATTR_COMPARATOR = new AttributeComparator();
    private static final NamespaceComparator NS_COMPARATOR = new NamespaceComparator();
    private static final Encoding ENCODING = Encoding.forName("UTF-8");
    private static final boolean[] whitespaceCharacter_ = new boolean[128];
    private static final boolean[] escapeTextCharacter_;
    private static final boolean[] escapeAttrCharacter_;

    public CanXmlResultBuilder(XsltResult xsltResult) {
        super(xsltResult.getUri());
        this.result_ = xsltResult;
    }

    private XmlWriter createXmlWriter() throws UnsupportedEncodingException {
        if (this.result_.getWriter() != null) {
            return new XmlWriter(this.result_.getWriter(), ENCODING, false);
        }
        OutputStream outputStream = this.result_.getOutputStream();
        boolean bl = outputStream == System.out || outputStream == System.err;
        return new XmlWriter(outputStream, ENCODING, bl);
    }

    public void startDocument(OutputFormat outputFormat) {
        try {
            this.out_ = this.createXmlWriter();
            this.nsDeclarations_ = new NamespaceSupport.Declaration[10];
            this.attributes_ = new Attribute[10];
            this.attributeCount_ = 0;
            this.textBuffer_ = new TextBuffer();
            this.textPartBuffer_ = new TextBuffer();
            this.nsSupport_ = new NamespaceSupport();
            this.beforeDocElement_ = true;
            this.level_ = new XmlLevel();
            this.level_.level = -1;
            this.indent_ = outputFormat.getIndent(false);
            if (this.indent_) {
                this.out_.setTabChars("  ");
            }
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    public void endDocument() {
        try {
            this.flush();
            this.out_.flush();
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    public void startElement(String string, String string2, NamespaceContext namespaceContext, boolean bl) {
        this.flush();
        this.elementStarted_ = true;
        this.beforeDocElement_ = false;
        this.nsSupport_.startElement(string, namespaceContext, this.level_.namespaceContext);
        this.level_ = (XmlLevel)this.level_.increase();
        this.level_.name = string2;
        this.level_.namespaceContext = namespaceContext;
        this.level_.isCDataSectionElement = bl;
        this.level_.disableEscpaping = bl;
    }

    public void endElement() {
        try {
            this.flush();
            this.nsSupport_.endElement();
            if (this.indent_) {
                this.out_.decreaseTab();
                this.printBreak();
            }
            this.out_.printOpenSlash();
            this.out_.print(this.level_.name);
            this.out_.printClose();
            this.level_ = (XmlLevel)this.level_.decrease();
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    public void addNamespace(String string, String string2, boolean bl) throws XsltException {
        if (bl) {
            if (!this.elementStarted_) {
                return;
            }
            if (this.attributeCount_ != 0) {
                return;
            }
        }
        this.nsSupport_.addDeclaration(string, string2, !bl);
    }

    public String getNamespacePrefix(String string) {
        return this.nsSupport_.getPrefix(string);
    }

    public void addAttribute(String string, String string2, String string3, String string4) {
        if (!this.elementStarted_) {
            throw new XsltException("cannot add attribute " + string + "='" + string4 + "' (no element open)");
        }
        if (string3 != null) {
            string = this.nsSupport_.adjustAttributeName(string, string2, string3);
        }
        Attribute attribute = new Attribute(string, string4);
        int n = 0;
        while (n < this.attributeCount_) {
            if (attribute.equals(this.attributes_[n])) {
                this.attributes_[n] = attribute;
                return;
            }
            ++n;
        }
        if (this.attributeCount_ == this.attributes_.length) {
            Attribute[] attributeArray = this.attributes_;
            this.attributes_ = new Attribute[2 * this.attributeCount_];
            System.arraycopy(attributeArray, 0, this.attributes_, 0, this.attributeCount_);
        }
        this.attributes_[this.attributeCount_++] = attribute;
    }

    public void addText(String string) {
        if (string.length() == 0) {
            return;
        }
        try {
            if (this.elementStarted_) {
                this.flushElement();
            }
            if (this.level_.isCDataSectionElement) {
                string = StringUtil.replace(string, "]]>", "]]]]><![CDATA[>");
            }
            this.textPartBuffer_.append(string);
            this.addText(this.textPartBuffer_.getBuffer(), this.textPartBuffer_.length(), this.textBuffer_, this.level_.disableEscpaping);
            this.textPartBuffer_.clear();
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    public void addTextUnescaped(String string) {
        this.level_.disableEscpaping = true;
        this.addText(string);
        this.level_.disableEscpaping = this.level_.isCDataSectionElement;
    }

    private void addText(char[] cArray, int n, TextBuffer textBuffer, boolean bl) {
        char c;
        boolean[] blArray;
        int n2 = 0;
        if (this.indent_ && !this.printedNonWhitespaceText_) {
            blArray = whitespaceCharacter_;
            while (n2 < n) {
                c = cArray[n2];
                if (c >= '\u0080' || !blArray[c]) {
                    this.printedNonWhitespaceText_ = true;
                    break;
                }
                textBuffer.append(c);
                ++n2;
            }
        }
        blArray = escapeTextCharacter_;
        while (n2 < n) {
            c = cArray[n2];
            if (c < '\u0080') {
                if (!blArray[c] || bl) {
                    textBuffer.append(c);
                } else {
                    switch (c) {
                        case '<': {
                            textBuffer.append("&lt;");
                            break;
                        }
                        case '>': {
                            textBuffer.append("&gt;");
                            break;
                        }
                        case '&': {
                            textBuffer.append("&amp;");
                            break;
                        }
                        case '\r': {
                            textBuffer.append("&#xD;");
                        }
                    }
                }
            } else if (ENCODING.isPrintable(c)) {
                textBuffer.append(c);
            } else {
                if (this.level_.isCDataSectionElement) {
                    textBuffer.append("]]>");
                }
                textBuffer.append("&#");
                textBuffer.append(Integer.toString(c));
                textBuffer.append(';');
                if (this.level_.isCDataSectionElement) {
                    textBuffer.append("<![CDATA[");
                }
            }
            ++n2;
        }
    }

    public void addComment(String string) {
        try {
            this.flush();
            if (this.indent_) {
                this.printBreak();
            } else {
                this.printToplevelBreak(false);
            }
            this.out_.print("<!--");
            this.out_.print(string);
            this.out_.print("-->");
            if (!this.indent_) {
                this.printToplevelBreak(true);
            }
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    public void addProcessingInstruction(String string, String string2) {
        try {
            this.flush();
            if (this.indent_) {
                this.printBreak();
            } else {
                this.printToplevelBreak(false);
            }
            this.out_.print("<?");
            this.out_.print(string);
            if (string2.length() > 0) {
                this.out_.printSpace();
                this.out_.print(string2);
            }
            this.out_.print("?>");
            if (!this.indent_) {
                this.printToplevelBreak(true);
            }
        }
        catch (Exception exception) {
            this.convertException(exception);
        }
    }

    private void printToplevelBreak(boolean bl) {
        if (this.level_.level == -1 && bl == this.beforeDocElement_) {
            this.out_.println();
        }
    }

    public void cleanup() {
        if (this.out_ != null) {
            this.out_.flush();
        }
        this.result_.cleanup();
    }

    private void flush() {
        if (this.elementStarted_) {
            this.flushElement();
        }
        if (this.textBuffer_.length() > 0) {
            try {
                if (this.level_.isCDataSectionElement) {
                    this.out_.print("<![CDATA[");
                    this.out_.write(this.textBuffer_.getBuffer(), 0, this.textBuffer_.length());
                    this.out_.print("]]>");
                } else {
                    this.out_.write(this.textBuffer_.getBuffer(), 0, this.textBuffer_.length());
                }
                this.textBuffer_.clear();
            }
            catch (Exception exception) {
                this.convertException(exception);
            }
        }
    }

    private void printNamespaces(NamespaceSupport.Declaration declaration) {
        int n = 0;
        while (declaration != null) {
            if (n == this.nsDeclarations_.length) {
                NamespaceSupport.Declaration[] declarationArray = this.nsDeclarations_;
                this.nsDeclarations_ = new NamespaceSupport.Declaration[2 * declarationArray.length];
                System.arraycopy(declarationArray, 0, this.nsDeclarations_, 0, n);
            }
            this.nsDeclarations_[n++] = declaration;
            declaration = declaration.next;
        }
        Quicksort.sort(NS_COMPARATOR, this.nsDeclarations_, 0, n - 1);
        int n2 = 0;
        while (n2 < n) {
            NamespaceSupport.Declaration declaration2 = this.nsDeclarations_[n2];
            this.printAttribute(declaration2.getName(), declaration2.uri);
            ++n2;
        }
    }

    private void printAttributes() {
        String string = this.nsSupport_.getUri("");
        int n = 0;
        while (n < this.attributeCount_) {
            Attribute attribute = this.attributes_[n];
            attribute.uri = attribute.prefix != null ? string : this.nsSupport_.getUri(attribute.prefix);
            ++n;
        }
        Quicksort.sort(ATTR_COMPARATOR, this.attributes_, 0, this.attributeCount_ - 1);
        int n2 = 0;
        while (n2 < this.attributeCount_) {
            Attribute attribute = this.attributes_[n2];
            this.printAttribute(attribute.qname, attribute.value);
            ++n2;
        }
    }

    private void printAttribute(String string, String string2) {
        this.out_.printSpace();
        this.out_.print(string);
        this.out_.printEqualsQuote();
        boolean[] blArray = escapeAttrCharacter_;
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c >= '\u007f' || !blArray[c]) {
                this.out_.write(c);
            } else {
                switch (c) {
                    case '<': {
                        this.out_.write("&lt;");
                        break;
                    }
                    case '&': {
                        this.out_.write("&amp;");
                        break;
                    }
                    case '\"': {
                        this.out_.write("&quot;");
                        break;
                    }
                    case '\t': {
                        this.out_.write("&#x9;");
                        break;
                    }
                    case '\n': {
                        this.out_.write("&#xA;");
                        break;
                    }
                    case '\r': {
                        this.out_.write("&#xD;");
                    }
                }
            }
            ++n2;
        }
        this.out_.printQuote();
    }

    private void flushElement() {
        if (this.elementStarted_) {
            try {
                this.elementStarted_ = false;
                if (this.indent_) {
                    this.printBreak();
                    this.out_.printOpen();
                    this.out_.print(this.level_.name);
                    this.out_.increaseTab();
                } else {
                    this.out_.printOpen();
                    this.out_.print(this.level_.name);
                }
                NamespaceSupport.Declaration declaration = this.nsSupport_.getElementDeclarations();
                if (declaration != null) {
                    this.printNamespaces(declaration);
                }
                if (this.attributeCount_ > 0) {
                    this.printAttributes();
                    this.attributeCount_ = 0;
                }
                this.out_.printClose();
            }
            catch (Exception exception) {
                this.convertException(exception);
            }
        }
    }

    private void printBreak() {
        if (!this.out_.newLineStarted() && !this.printedNonWhitespaceText_) {
            this.out_.println();
        }
        this.printedNonWhitespaceText_ = false;
    }

    static {
        CanXmlResultBuilder.whitespaceCharacter_[9] = true;
        CanXmlResultBuilder.whitespaceCharacter_[32] = true;
        CanXmlResultBuilder.whitespaceCharacter_[10] = true;
        CanXmlResultBuilder.whitespaceCharacter_[13] = true;
        escapeTextCharacter_ = new boolean[128];
        CanXmlResultBuilder.escapeTextCharacter_[13] = true;
        CanXmlResultBuilder.escapeTextCharacter_[60] = true;
        CanXmlResultBuilder.escapeTextCharacter_[62] = true;
        CanXmlResultBuilder.escapeTextCharacter_[38] = true;
        escapeAttrCharacter_ = new boolean[128];
        CanXmlResultBuilder.escapeAttrCharacter_[60] = true;
        CanXmlResultBuilder.escapeAttrCharacter_[38] = true;
        CanXmlResultBuilder.escapeAttrCharacter_[34] = true;
        CanXmlResultBuilder.escapeAttrCharacter_[9] = true;
        CanXmlResultBuilder.escapeAttrCharacter_[10] = true;
        CanXmlResultBuilder.escapeAttrCharacter_[13] = true;
    }

    private static class NamespaceComparator
    implements Comparator {
        private NamespaceComparator() {
        }

        public int compare(Object object, Object object2) {
            NamespaceSupport.Declaration declaration = (NamespaceSupport.Declaration)object;
            NamespaceSupport.Declaration declaration2 = (NamespaceSupport.Declaration)object2;
            if (declaration.prefix == null) {
                return 1;
            }
            if (declaration2.prefix == null) {
                return -1;
            }
            return declaration.prefix.compareTo(declaration2.prefix);
        }
    }

    private static class AttributeComparator
    implements Comparator {
        private AttributeComparator() {
        }

        public int compare(Object object, Object object2) {
            Attribute attribute = (Attribute)object;
            Attribute attribute2 = (Attribute)object2;
            boolean bl = attribute.uri != null;
            if (bl == (attribute2.uri != null)) {
                int n;
                int n2 = n = bl ? attribute.uri.compareTo(attribute2.uri) : 0;
                if (n == 0) {
                    n = attribute.localName.compareTo(attribute2.localName);
                }
                return n;
            }
            return bl ? 1 : -1;
        }
    }

    private static class Attribute {
        public final String qname;
        public final String prefix;
        public final String localName;
        public final String value;
        public String uri;

        public Attribute(String string, String string2) {
            this.qname = string;
            this.value = string2;
            int n = string.indexOf(58);
            if (n >= 0) {
                this.prefix = string.substring(0, n);
                this.localName = string.substring(n + 1);
            } else {
                this.prefix = null;
                this.localName = string;
            }
        }

        public boolean equals(Object object) {
            return ((Attribute)object).qname.equals(this.qname);
        }

        public int hashCode() {
            return this.qname.hashCode();
        }
    }

    private static class XmlLevel
    extends ResultLevel {
        public String name;
        public NamespaceContext namespaceContext;
        public boolean isCDataSectionElement;
        public boolean disableEscpaping;

        private XmlLevel() {
        }

        public ResultLevel create() {
            return new XmlLevel();
        }
    }
}

