/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.extension;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jd.xml.xpath.XPathContext;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.model.XPathNode;
import jd.xml.xpath.object.XBoolean;
import jd.xml.xpath.object.XEmptyNodeSet;
import jd.xml.xpath.object.XMutableNodeSet;
import jd.xml.xpath.object.XNodeSetFactory;
import jd.xml.xpath.object.XNumber;
import jd.xml.xpath.object.XObject;
import jd.xml.xpath.object.XSingleNodeSet;
import jd.xml.xpath.object.XString;
import jd.xml.xslt.XsltContext;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.extension.ExtensionFunction;
import jd.xml.xslt.extension.JavaXsltContext;
import jd.xml.xslt.extension.XExternalObject;

public class JavaFunction
extends ExtensionFunction {
    private Expression object_;
    private Method method_;
    private Constructor constructor_;
    private Class[] argTypes_;
    private boolean hasJdContext_;
    private boolean hasW3cContext_;

    public JavaFunction(Constructor constructor, boolean bl, boolean bl2) {
        super(constructor.getName(), constructor.getParameterTypes().length);
        this.constructor_ = constructor;
        this.argTypes_ = constructor.getParameterTypes();
        this.hasJdContext_ = bl;
        this.hasW3cContext_ = bl2;
    }

    public JavaFunction(Expression expression, Method method, boolean bl, boolean bl2) {
        super(method.getName(), JavaFunction.getArgCount(expression, method, bl, bl2));
        this.object_ = expression;
        this.method_ = method;
        this.argTypes_ = method.getParameterTypes();
        this.hasJdContext_ = bl;
        this.hasW3cContext_ = bl2;
    }

    private static int getArgCount(Expression expression, Method method, boolean bl, boolean bl2) {
        int n = method.getParameterTypes().length;
        if (expression != null) {
            ++n;
        }
        if (bl || bl2) {
            --n;
        }
        return n;
    }

    public XObject toXObject(XPathContext xPathContext) {
        Object object = null;
        Object[] objectArray = this.buildArguments(xPathContext, this.arguments_);
        Throwable throwable = null;
        try {
            if (this.method_ != null) {
                Object object2 = null;
                if (this.object_ != null) {
                    object2 = this.object_.toXObject(xPathContext).toValue();
                }
                object = this.method_.invoke(object2, objectArray);
            } else {
                object = this.constructor_.newInstance(objectArray);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException.getTargetException();
        }
        catch (Exception exception) {
            throwable = exception;
        }
        if (throwable != null) {
            throw new XsltException("call to extension function '" + this.getFunctionType().name + "' failed", throwable);
        }
        return this.buildResult(object);
    }

    private Object[] buildArguments(XPathContext xPathContext, Expression[] expressionArray) {
        int n;
        int n2 = n = expressionArray == null ? 0 : expressionArray.length;
        if (this.hasJdContext_ || this.hasW3cContext_) {
            ++n;
        }
        if (this.object_ != null) {
            --n;
        }
        Object[] objectArray = null;
        if (n > 0) {
            objectArray = new Object[n];
            int n3 = 0;
            int n4 = 0;
            if (this.hasW3cContext_) {
                objectArray[n3++] = new JavaXsltContext(XsltContext.cast(xPathContext));
            } else if (this.hasJdContext_) {
                objectArray[n3++] = XsltContext.cast(xPathContext);
            }
            if (this.object_ != null) {
                ++n4;
            }
            while (n3 < n) {
                XObject xObject = expressionArray[n4++].toXObject(xPathContext);
                objectArray[n3] = xObject.toValue(this.argTypes_[n3]);
                ++n3;
            }
        }
        return objectArray;
    }

    private XObject buildResult(Object object) {
        if (object == null) {
            if (this.method_.getReturnType() == Void.TYPE) {
                return XEmptyNodeSet.INSTANCE;
            }
            return new XExternalObject(null);
        }
        if (object instanceof String) {
            return new XString((String)object);
        }
        if (object instanceof Number) {
            return new XNumber(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return XBoolean.getBoolean((Boolean)object);
        }
        if (object instanceof XObject) {
            return (XObject)object;
        }
        if (object instanceof XPathNode) {
            return new XSingleNodeSet((XPathNode)object);
        }
        if (object instanceof XPathNode[]) {
            XPathNode[] xPathNodeArray = (XPathNode[])object;
            int n = xPathNodeArray.length;
            XMutableNodeSet xMutableNodeSet = XNodeSetFactory.create(0, n);
            int n2 = 0;
            while (n2 < n) {
                xMutableNodeSet.addNode(xPathNodeArray[n2]);
                ++n2;
            }
            return xMutableNodeSet;
        }
        return new XExternalObject(object);
    }
}

