/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import org.apache.xalan.xsltc.NodeIterator;
import org.apache.xalan.xsltc.dom.NodeIteratorBase;

public final class NthIterator
extends NodeIteratorBase {
    private NodeIterator _source;
    private final int _position;
    private boolean _ready;

    public NthIterator(NodeIterator source, int n) {
        this._source = source;
        this._position = n;
    }

    public void setRestartable(boolean isRestartable) {
        this._isRestartable = isRestartable;
        this._source.setRestartable(isRestartable);
    }

    public int next() {
        if (this._ready && this._position > 0) {
            this._ready = false;
            int pos = this._position;
            int n = pos - 1;
            while (n-- > 0) {
                if (this._source.next() != 0) continue;
                return 0;
            }
            return this._source.next();
        }
        return 0;
    }

    public NodeIterator setStartNode(int node) {
        if (this._isRestartable) {
            this._source.setStartNode(node);
            this._ready = true;
        }
        return this;
    }

    public NodeIterator reset() {
        this._source.reset();
        this._ready = true;
        return this;
    }

    public int getLast() {
        return 1;
    }

    public int getPosition() {
        return 1;
    }

    public boolean isReverse() {
        return this._source.isReverse();
    }

    public void setMark() {
        this._source.setMark();
    }

    public void gotoMark() {
        this._source.gotoMark();
    }

    public NodeIterator cloneIterator() {
        NodeIterator clone = this._source.cloneIterator();
        NthIterator other = new NthIterator(clone, this._position);
        other.setRestartable(false);
        return other.reset();
    }
}

