/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

public class IntList {
    private int[] _array;
    private int _limit;
    private int fillval = 0;
    private static final int _default_size = 128;

    public IntList() {
        this(128);
    }

    public IntList(int n) {
        this(n, 0);
    }

    public IntList(IntList intList) {
        this(intList._array.length);
        System.arraycopy(intList._array, 0, this._array, 0, this._array.length);
        this._limit = intList._limit;
    }

    public IntList(int n, int n2) {
        this._array = new int[n];
        if (this.fillval != 0) {
            this.fillval = n2;
            this.fillArray(this.fillval, this._array, 0);
        }
        this._limit = 0;
    }

    private void fillArray(int n, int[] nArray, int n2) {
        for (int i = n2; i < nArray.length; ++i) {
            nArray[i] = n;
        }
    }

    public void add(int n, int n2) {
        if (n > this._limit) {
            throw new IndexOutOfBoundsException();
        }
        if (n == this._limit) {
            this.add(n2);
        } else {
            if (this._limit == this._array.length) {
                this.growArray(this._limit * 2);
            }
            System.arraycopy(this._array, n, this._array, n + 1, this._limit - n);
            this._array[n] = n2;
            ++this._limit;
        }
    }

    public boolean add(int n) {
        if (this._limit == this._array.length) {
            this.growArray(this._limit * 2);
        }
        this._array[this._limit++] = n;
        return true;
    }

    public boolean addAll(IntList intList) {
        if (intList._limit != 0) {
            if (this._limit + intList._limit > this._array.length) {
                this.growArray(this._limit + intList._limit);
            }
            System.arraycopy(intList._array, 0, this._array, this._limit, intList._limit);
            this._limit += intList._limit;
        }
        return true;
    }

    public boolean addAll(int n, IntList intList) {
        if (n > this._limit) {
            throw new IndexOutOfBoundsException();
        }
        if (intList._limit != 0) {
            if (this._limit + intList._limit > this._array.length) {
                this.growArray(this._limit + intList._limit);
            }
            System.arraycopy(this._array, n, this._array, n + intList._limit, this._limit - n);
            System.arraycopy(intList._array, 0, this._array, n, intList._limit);
            this._limit += intList._limit;
        }
        return true;
    }

    public void clear() {
        this._limit = 0;
    }

    public boolean contains(int n) {
        boolean bl = false;
        for (int i = 0; !bl && i < this._limit; ++i) {
            if (this._array[i] != n) continue;
            bl = true;
        }
        return bl;
    }

    public boolean containsAll(IntList intList) {
        boolean bl = true;
        if (this != intList) {
            for (int i = 0; bl && i < intList._limit; ++i) {
                if (this.contains(intList._array[i])) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = this == object;
        if (!bl && object != null && object.getClass() == this.getClass()) {
            IntList intList = (IntList)object;
            if (intList._limit == this._limit) {
                bl = true;
                for (int i = 0; bl && i < this._limit; ++i) {
                    bl = this._array[i] == intList._array[i];
                }
            }
        }
        return bl;
    }

    public int get(int n) {
        if (n >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        return this._array[n];
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this._limit; ++i) {
            n = 31 * n + this._array[i];
        }
        return n;
    }

    public int indexOf(int n) {
        int n2;
        for (n2 = 0; n2 < this._limit && n != this._array[n2]; ++n2) {
        }
        if (n2 == this._limit) {
            n2 = -1;
        }
        return n2;
    }

    public boolean isEmpty() {
        return this._limit == 0;
    }

    public int lastIndexOf(int n) {
        int n2;
        for (n2 = this._limit - 1; n2 >= 0 && n != this._array[n2]; --n2) {
        }
        return n2;
    }

    public int remove(int n) {
        if (n >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this._array[n];
        System.arraycopy(this._array, n + 1, this._array, n, this._limit - n);
        --this._limit;
        return n2;
    }

    public boolean removeValue(int n) {
        boolean bl = false;
        for (int i = 0; !bl && i < this._limit; ++i) {
            if (n != this._array[i]) continue;
            if (i + 1 < this._limit) {
                System.arraycopy(this._array, i + 1, this._array, i, this._limit - i);
            }
            --this._limit;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(IntList intList) {
        boolean bl = false;
        for (int i = 0; i < intList._limit; ++i) {
            if (!this.removeValue(intList._array[i])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(IntList intList) {
        boolean bl = false;
        int n = 0;
        while (n < this._limit) {
            if (!intList.contains(this._array[n])) {
                this.remove(n);
                bl = true;
                continue;
            }
            ++n;
        }
        return bl;
    }

    public int set(int n, int n2) {
        if (n >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this._array[n];
        this._array[n] = n2;
        return n3;
    }

    public int size() {
        return this._limit;
    }

    public int[] toArray() {
        int[] nArray = new int[this._limit];
        System.arraycopy(this._array, 0, nArray, 0, this._limit);
        return nArray;
    }

    public int[] toArray(int[] nArray) {
        int[] nArray2;
        if (nArray.length == this._limit) {
            System.arraycopy(this._array, 0, nArray, 0, this._limit);
            nArray2 = nArray;
        } else {
            nArray2 = this.toArray();
        }
        return nArray2;
    }

    private void growArray(int n) {
        int n2 = n == this._array.length ? n + 1 : n;
        int[] nArray = new int[n2];
        if (this.fillval != 0) {
            this.fillArray(this.fillval, nArray, this._array.length);
        }
        System.arraycopy(this._array, 0, nArray, 0, this._limit);
        this._array = nArray;
    }
}

