/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BitVector;

final class SegmentMergeInfo {
    Term term;
    int base;
    SegmentTermEnum termEnum;
    SegmentReader reader;
    SegmentTermPositions postings;
    int[] docMap = null;

    SegmentMergeInfo(int n, SegmentTermEnum segmentTermEnum, SegmentReader segmentReader) throws IOException {
        this.base = n;
        this.reader = segmentReader;
        this.termEnum = segmentTermEnum;
        this.term = segmentTermEnum.term();
        this.postings = new SegmentTermPositions(segmentReader);
        if (this.reader.deletedDocs != null) {
            BitVector bitVector = this.reader.deletedDocs;
            int n2 = this.reader.maxDoc();
            this.docMap = new int[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                this.docMap[n4] = bitVector.get(n4) ? -1 : n3++;
                ++n4;
            }
        }
    }

    final boolean next() throws IOException {
        if (this.termEnum.next()) {
            this.term = this.termEnum.term();
            return true;
        }
        this.term = null;
        return false;
    }

    final void close() throws IOException {
        this.termEnum.close();
        this.postings.close();
    }
}

