<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  
  <xsl:output method="html" indent="yes"/>
  
  <xsl:template match="bebop:dhtmleditor"
    xmlns:bebop="http://www.arsdigita.com/bebop/1.0">
    <xsl:variable name="firstMatch"><xsl:value-of select="//bebop:dhtmleditor/@name"/></xsl:variable>
    <xsl:if test="@name=$firstMatch">    
      <script type="text/javascript">
        _editor_url = "/assets/htmlarea/";
       var numEd = 0;
      </script>

      <script type="text/javascript" src="/assets/htmlarea/htmlarea.js"/>
      <script type="text/javascript" src="/assets/htmlarea/lang/en.js"/>
      <script type="text/javascript" src="/assets/htmlarea/dialog.js"/>
      <script type="text/javascript" src="/assets/htmlarea/popupwin.js"/>

      <script type="text/javascript">
        <xsl:for-each select="bebop:plugin">
          HTMLArea.loadPlugin("<xsl:value-of select="@name"/>");
        </xsl:for-each>
      </script>
    
      <xsl:if test="bebop:config/@path">
        <script type="text/javascript" src="{bebop:config/@path}"/>    
      </xsl:if>

      <style type="text/css">
        @import url(/assets/htmlarea/htmlarea.css);
      
        textarea { background-color: #fff; border: 1px solid 00f; }
      </style>
    </xsl:if> 
    <textarea id="ta_{@name}" name="{@name}" style="width:100%" rows="{@rows}" cols="{@cols}" wrap="{@wrap}">
      <xsl:value-of disable-output-escaping="yes" select="text()"/>
    </textarea>
    
    <script type="text/javascript" defer="1">
      var config_<xsl:value-of select="@name"/> = new <xsl:value-of select="bebop:config/@name"/>();
      var editor_<xsl:value-of select="@name"/> = new HTMLArea("ta_<xsl:value-of select="@name"/>",
                                config_<xsl:value-of select="@name"/>);
      <xsl:for-each select="bebop:plugin">
        editor_<xsl:value-of select="../@name"/>.registerPlugin("<xsl:value-of select="@name"/>");
      </xsl:for-each>
        setTimeout(function() {
          editor_<xsl:value-of select="@name"/>.generate();
        }, 500*numEd);
      numEd++;
    </script>
    
  </xsl:template>
</xsl:stylesheet>
