/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.QFrame;

class QValue {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/QValue.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private QFrame m_frame;
    private String m_column = null;
    private Code m_sql = null;

    QValue(QFrame frame, String column) {
        this.m_frame = frame;
        this.m_column = column;
    }

    QValue(QFrame frame, Code sql) {
        this.m_frame = frame;
        this.m_sql = sql;
    }

    QFrame getFrame() {
        return this.m_frame;
    }

    String getTable() {
        return this.m_frame.getTable();
    }

    String getColumn() {
        return this.m_column;
    }

    boolean isNullable() {
        QFrame frame = this.m_frame.getDuplicate();
        if (frame.isOuter()) {
            return true;
        }
        if (frame.getTable() == null) {
            return true;
        }
        Root root = frame.getGenerator().getRoot();
        Table t = root.getTable(frame.getTable());
        if (t == null) {
            return true;
        }
        Column col = t.getColumn(this.m_column);
        return col.isNullable();
    }

    Code emit() {
        if (this.m_sql != null) {
            return this.m_sql;
        }
        return new Code(this.m_frame.alias() + "." + this.m_column);
    }

    public String toString() {
        if (this.m_sql != null) {
            return this.m_sql.toString();
        }
        return this.m_frame.alias() + "." + this.m_column;
    }
}

