/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.common.Path;
import com.redhat.persistence.common.SQL;
import com.redhat.persistence.common.SQLToken;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.Constraint;
import com.redhat.persistence.metadata.JoinFrom;
import com.redhat.persistence.metadata.JoinThrough;
import com.redhat.persistence.metadata.JoinTo;
import com.redhat.persistence.metadata.Mapping;
import com.redhat.persistence.metadata.MetadataException;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.SQLBlock;
import com.redhat.persistence.metadata.Static;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.Value;
import com.redhat.persistence.oql.QFrame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Code {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/Code.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$redhat$persistence$oql$Code == null ? (class$com$redhat$persistence$oql$Code = Code.class$("com.redhat.persistence.oql.Code")) : class$com$redhat$persistence$oql$Code));
    static final Code TRUE = new Code("1 = 1");
    static final Code FALSE = new Code("1 = 0");
    static final Code NULL = new Code("null");
    static final Code EMPTY = new Code();
    private StringBuffer m_sql;
    private int m_lower;
    private int m_upper;
    private int m_hash = 0;
    private List m_bindings;
    private String m_str = null;
    static /* synthetic */ Class class$com$redhat$persistence$oql$Code;

    private Code(StringBuffer sql, List bindings) {
        this.m_sql = sql;
        this.m_bindings = bindings;
    }

    Code(String sql, List bindings) {
        this.m_sql = new StringBuffer();
        this.m_lower = 0;
        this.append(sql);
        this.m_bindings = bindings;
    }

    Code(String sql) {
        this(sql, Collections.EMPTY_LIST);
    }

    Code() {
        this("");
    }

    public String getSQL() {
        if (this.m_str == null) {
            this.m_str = this.m_sql.substring(this.m_lower, this.m_upper);
        }
        return this.m_str;
    }

    public List getBindings() {
        return this.m_bindings;
    }

    boolean isTrue() {
        return this.equals(TRUE);
    }

    boolean isFalse() {
        return this.equals(FALSE);
    }

    boolean isNull() {
        return this.equals(NULL);
    }

    boolean isEmpty() {
        return this.equals(EMPTY);
    }

    Code add(String sql) {
        Code result = new Code(this.m_sql, this.m_bindings);
        result.m_lower = this.m_lower;
        result.append(sql);
        return result;
    }

    Code add(Code code) {
        ArrayList bindings;
        if (this.m_bindings.isEmpty()) {
            bindings = code.m_bindings;
        } else if (code.m_bindings.isEmpty()) {
            bindings = this.m_bindings;
        } else {
            bindings = new ArrayList();
            bindings.addAll(this.m_bindings);
            bindings.addAll(code.m_bindings);
        }
        Code result = new Code(this.m_sql, bindings);
        result.m_lower = this.m_lower;
        result.append(code.m_sql, code.m_lower, code.m_upper);
        return result;
    }

    private void append(String str) {
        for (int i = 0; i < str.length(); ++i) {
            this.append(str.charAt(i));
        }
        this.m_upper = this.m_sql.length();
    }

    private void append(StringBuffer src, int lower, int upper) {
        for (int i = lower; i < upper; ++i) {
            this.append(src.charAt(i));
        }
        this.m_upper = this.m_sql.length();
    }

    private void append(char c) {
        this.m_hash *= 31;
        this.m_hash += c;
        this.m_sql.append(c);
    }

    private int size() {
        return this.m_upper - this.m_lower;
    }

    private char charAt(int i) {
        return this.m_sql.charAt(this.m_lower + i);
    }

    public int hashCode() {
        return this.m_hash ^ ((Object)this.getBindings()).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Code)) {
            return super.equals(o);
        }
        Code c = (Code)o;
        if (this == c) {
            return true;
        }
        if (this.size() != c.size()) {
            return false;
        }
        if (this.hashCode() != c.hashCode()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.charAt(i) == c.charAt(i)) continue;
            return false;
        }
        return ((Object)this.getBindings()).equals(c.getBindings());
    }

    Code resolve(Map bindings, Root root) {
        Code result = new Code("", new ArrayList());
        int index = 0;
        boolean escape = false;
        for (int i = this.m_lower; i < this.m_upper; ++i) {
            char c = this.m_sql.charAt(i);
            if (!escape && c == '?') {
                int type;
                Object value;
                Binding b;
                if ((b = (Binding)this.m_bindings.get(index++)).getKey() == null) {
                    value = b.getValue();
                    type = b.getType();
                } else {
                    value = bindings.get(b.getKey());
                    if (value == null) {
                        throw new IllegalStateException("no value for key: " + b.getKey());
                    }
                    Adapter ad = root.getAdapter(value.getClass());
                    type = ad.defaultJDBCType();
                }
                result.m_bindings.add(new Binding(b.getKey(), value, type));
            } else if (!escape && c == '\'') {
                escape = true;
            } else if (escape && c == '\'') {
                escape = false;
            }
            result.append(c);
        }
        result.m_upper = result.m_sql.length();
        return result;
    }

    public String toString() {
        return "<" + this.getSQL() + ": " + this.getBindings() + ">";
    }

    static Code join(Collection parts, String sep) {
        Code result = null;
        Iterator it = parts.iterator();
        while (it.hasNext()) {
            Code part = (Code)it.next();
            if (result == null) {
                result = part;
                continue;
            }
            result = result.add(sep).add(part);
        }
        return result;
    }

    private static String[] names(Column[] columns, String alias) {
        String[] result = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            Column col = columns[i];
            result[i] = alias == null ? col.getName() : alias + "." + col.getName();
        }
        return result;
    }

    static Mapping getMapping(Property prop) {
        Root root = prop.getRoot();
        if (root == null) {
            throw new IllegalStateException("null root: " + prop);
        }
        ObjectMap om = root.getObjectMap(prop.getContainer());
        if (om == null) {
            throw new IllegalStateException("null object map: " + prop);
        }
        Mapping m = om.getMapping(Path.get(prop.getName()));
        if (m == null) {
            throw new IllegalStateException("null mapping: " + prop);
        }
        return m;
    }

    private static boolean isStaticAttribute(Mapping m) {
        if (m instanceof Static) {
            return true;
        }
        ObjectMap map = m.getObjectMap();
        return map.getTable() == null && map.getRetrieveAll() != null;
    }

    static String[] columns(final Property prop, final String alias) {
        Mapping m = Code.getMapping(prop);
        if (m.getRetrieve() != null) {
            return Code.columns(prop.getType(), alias);
        }
        if (Code.isStaticAttribute(m)) {
            ObjectMap map = m.getObjectMap();
            SQLBlock block = map.getRetrieveAll();
            if (block == null && m instanceof Static) {
                throw new MetadataException(map.getRoot(), map, "Specify metadata for property " + prop.getName() + " in type " + prop.getContainer().getQualifiedName() + " or include a retrieve all for the type");
            }
            return Code.columns(Code.paths(prop.getType(), m.getPath()), block);
        }
        final String[][] result = new String[][]{null};
        m.dispatch(new Mapping.Switch(){

            public void onValue(Value v) {
                result[0] = Code.names(new Column[]{v.getColumn()}, alias);
            }

            public void onJoinTo(JoinTo j) {
                result[0] = Code.columns(j.getKey(), prop.getType(), alias);
            }

            public void onJoinFrom(JoinFrom j) {
                result[0] = Code.columns(j.getKey().getTable().getPrimaryKey(), prop.getType(), alias);
            }

            public void onJoinThrough(JoinThrough jt) {
                result[0] = Code.columns(jt.getTo(), prop.getType(), alias);
            }

            public void onStatic(Static s) {
                throw new IllegalStateException();
            }
        });
        return result[0];
    }

    static String[] columns(Property prop, QFrame frame) {
        ArrayList result = new ArrayList();
        if (Code.columns(prop, frame, null, result)) {
            return result.toArray(new String[result.size()]);
        }
        return null;
    }

    private static boolean columns(Property prop, QFrame frame, Path prefix, List result) {
        prefix = Path.add(prefix, prop.getName());
        Collection props = Code.properties(prop.getType());
        if (props.isEmpty()) {
            if (frame.hasMapping(prefix)) {
                result.add(frame.getMapping(prefix));
                return true;
            }
            return false;
        }
        Iterator it = props.iterator();
        while (it.hasNext()) {
            Property p = (Property)it.next();
            if (Code.columns(p, frame, prefix, result)) continue;
            return false;
        }
        return true;
    }

    static void equals(String[] left, String[] right, StringBuffer buf) {
        if (left.length != right.length) {
            throw new IllegalArgumentException("left size does not match right size\nleft = " + Arrays.asList(left) + "\nright= " + Arrays.asList(right));
        }
        for (int i = 0; i < left.length; ++i) {
            buf.append(left[i]);
            buf.append(" = ");
            buf.append(right[i]);
            if (i >= left.length - 1) continue;
            buf.append(" and ");
        }
    }

    static String table(Property prop) {
        Mapping m = Code.getMapping(prop);
        if (m.getRetrieve() != null) {
            return Code.table(prop.getType());
        }
        if (Code.isStaticAttribute(m)) {
            return null;
        }
        final String[] result = new String[]{null};
        m.dispatch(new Mapping.Switch(){

            public void onValue(Value v) {
                result[0] = v.getTable().getName();
            }

            public void onJoinTo(JoinTo j) {
                result[0] = j.getTable().getName();
            }

            public void onJoinFrom(JoinFrom j) {
                result[0] = j.getKey().getTable().getName();
            }

            public void onJoinThrough(JoinThrough jt) {
                result[0] = jt.getFrom().getTable().getName();
            }

            public void onStatic(Static s) {
                throw new IllegalStateException();
            }
        });
        return result[0];
    }

    static String table(ObjectType type) {
        ObjectMap om = type.getRoot().getObjectMap(type);
        if (om.getRetrieveAll() != null) {
            return "(" + om.getRetrieveAll().getSQL() + ")";
        }
        return Code.table(om).getName();
    }

    static Table table(ObjectMap map) {
        for (ObjectMap om = map; om != null; om = om.getSuperMap()) {
            Table table = om.getTable();
            if (table == null) continue;
            return table;
        }
        throw new MetadataException(map.getRoot(), map, "No retrieve all or mapping metadata for type " + map.getObjectType().getQualifiedName());
    }

    static void bind(SQL sql, Map values, StringBuffer buf) {
        for (SQLToken t = sql.getFirst(); t != null; t = t.getNext()) {
            if (t.isBind()) {
                Path key = Path.get(t.getImage().substring(1));
                String value = (String)values.get(key);
                if (value == null) {
                    throw new IllegalStateException("no value for: " + key + " in " + values);
                }
                buf.append(value);
                continue;
            }
            buf.append(t.getImage());
        }
    }

    static Path[] paths(ObjectType type, Path parent) {
        ArrayList result = new ArrayList();
        Code.paths(type, parent, result);
        return result.toArray(new Path[result.size()]);
    }

    static void paths(ObjectType type, Path parent, Collection result) {
        Collection props = Code.properties(type);
        if (props.isEmpty()) {
            if (parent != null) {
                result.add(parent);
            }
            return;
        }
        Iterator it = props.iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            Code.paths(prop.getType(), Path.add(parent, prop.getName()), result);
        }
    }

    static Map map(Path[] keys, String[] values) {
        HashMap<Path, String> result = new HashMap<Path, String>();
        for (int i = 0; i < keys.length; ++i) {
            result.put(keys[i], values[i]);
        }
        return result;
    }

    static String[] columns(Path[] paths, SQLBlock block) {
        String[] result = new String[paths.length];
        for (int i = 0; i < result.length; ++i) {
            Path column = block.getMapping(paths[i]);
            if (column == null) {
                throw new IllegalStateException("no mapping for path: " + paths[i]);
            }
            result[i] = column.getPath();
        }
        return result;
    }

    static String[] columns(ObjectType type, String alias) {
        ObjectMap om = type.getRoot().getObjectMap(type);
        if (om.getRetrieveAll() != null) {
            String[] columns = Code.columns(Code.paths(type, null), om.getRetrieveAll());
            if (alias == null) {
                return columns;
            }
            return Code.concat(alias + ".", columns);
        }
        return Code.names(Code.cols(type), alias);
    }

    static String[] columns(Constraint c, ObjectType type, String alias) {
        return Code.names(Code.cols(c, type), alias);
    }

    private static Column[] cols(Constraint c, ObjectType type) {
        Column[] cols = c.getColumns();
        Root root = type.getRoot();
        ObjectType basetype = type.getBasetype();
        ObjectMap map = root.getObjectMap(basetype);
        Column[] currentOrder = Code.table(map).getPrimaryKey().getColumns();
        Column[] desiredOrder = Code.cols(basetype);
        return Code.sort(cols, currentOrder, desiredOrder);
    }

    private static Column[] cols(ObjectType type) {
        Root root = type.getRoot();
        ObjectMap map = root.getObjectMap(type);
        if (type.getSupertype() == null) {
            List props = map.getKeyProperties();
            final ArrayList result = new ArrayList();
            Iterator it = props.iterator();
            while (it.hasNext()) {
                final Property prop = (Property)it.next();
                Mapping mapping = map.getMapping(Path.get(prop.getName()));
                mapping.dispatch(new Mapping.Switch(){

                    public void onValue(Value m) {
                        result.add(m.getColumn());
                    }

                    public void onJoinTo(JoinTo m) {
                        result.addAll(Arrays.asList(Code.cols(m.getKey(), prop.getType())));
                    }

                    public void onJoinFrom(JoinFrom m) {
                        throw new UnsupportedOperationException();
                    }

                    public void onJoinThrough(JoinThrough m) {
                        throw new UnsupportedOperationException();
                    }

                    public void onStatic(Static m) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            return result.toArray(new Column[0]);
        }
        return Code.cols(Code.table(map).getPrimaryKey(), type);
    }

    private static Column[] sort(Column[] toSort, Column[] currentOrder, Column[] desiredOrder) {
        int length = toSort.length;
        if (length != currentOrder.length || length != desiredOrder.length) {
            throw new IllegalArgumentException("length of arrays differs");
        }
        Column[] result = new Column[length];
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < length; ++j) {
                if (!desiredOrder[i].equals(currentOrder[j])) continue;
                result[i] = toSort[j];
                break;
            }
            if (result[i] != null) continue;
            throw new IllegalStateException();
        }
        return result;
    }

    static String[] concat(String prefix, String[] strs) {
        String[] result = new String[strs.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = prefix + strs[i];
        }
        return result;
    }

    static int span(ObjectType type) {
        Collection props = Code.properties(type);
        if (props.isEmpty()) {
            return 1;
        }
        int result = 0;
        Iterator it = props.iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            result += Code.span(prop.getType());
        }
        return result;
    }

    static Collection properties(ObjectType type) {
        List props = type.getKeyProperties();
        if (props.isEmpty()) {
            return type.getImmediateProperties();
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Binding {
        private Object m_key;
        private Object m_value;
        private int m_type;

        Binding(Object key, Object value, int type) {
            this.m_key = key;
            this.m_value = value;
            this.m_type = type;
        }

        public Object getKey() {
            return this.m_key;
        }

        public Object getValue() {
            return this.m_value;
        }

        public int getType() {
            return this.m_type;
        }

        public int hashCode() {
            return this.m_value.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Binding) {
                Binding b = (Binding)o;
                return this.m_value.equals(b.m_value);
            }
            return super.equals(o);
        }

        public String toString() {
            return "(" + this.m_value.toString() + ": " + this.m_value.getClass() + ", " + Column.getTypeName(this.m_type) + ")";
        }
    }
}

