/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.metadata;

import com.arsdigita.util.UncheckedWrapperException;
import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.Table;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class Constraint {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/metadata/Constraint.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Table m_table;
    private String m_name;
    private Column[] m_columns;
    private static final char[] sourceBytes = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_'};

    Constraint(Table table, String name, Column[] columns) {
        this.m_table = table;
        this.m_name = name;
        this.m_columns = columns;
        if (this.m_table.getConstraint(this.getClass(), this.m_columns) != null) {
            throw new IllegalArgumentException("Table already has constraint: " + this.m_table.getName());
        }
        this.m_table.addConstraint(this);
        HashSet<Column> cols = new HashSet<Column>();
        for (int i = 0; i < this.m_columns.length; ++i) {
            this.m_columns[i].addConstraint(this);
            cols.add(this.m_columns[i]);
            if (this.m_columns[i].getTable().equals(table)) continue;
            throw new IllegalArgumentException("All column constraints must be from the same table.");
        }
        if (cols.size() != this.m_columns.length) {
            throw new IllegalArgumentException("Duplicate columns");
        }
        if (this.m_name == null) {
            this.generateName();
        }
    }

    private String generateName() {
        return Constraint.generateName(this.m_table, this.getSortedColumns(), this.getSuffix());
    }

    static String generateName(Table table, List cols, String suffix) {
        StringBuffer buf = new StringBuffer();
        buf.append(table.getName());
        Iterator it = cols.iterator();
        while (it.hasNext()) {
            Column col = (Column)it.next();
            buf.append("_");
            buf.append(col.getName());
        }
        String name = buf.toString();
        buf = new StringBuffer(Constraint.abbreviate(name, 22));
        buf.append(suffix);
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] bytes = digest.digest((name + suffix).getBytes());
            char[] hash = new char[5];
            for (int i = 0; i < 5; ++i) {
                int intValue = new Byte(bytes[i]).intValue();
                if (intValue < 0) {
                    intValue *= -1;
                }
                hash[i] = sourceBytes[intValue %= sourceBytes.length];
            }
            buf.append("_" + new String(hash));
        }
        catch (GeneralSecurityException e) {
            throw new UncheckedWrapperException(e);
        }
        String result = buf.toString();
        return result;
    }

    private static final String abbreviate(String name, int length) {
        if (name == null || name.length() <= length) {
            return name;
        }
        int minSize = 3;
        boolean allMinSizeOrLess = true;
        StringBuffer result = new StringBuffer();
        int charsRemoved = 0;
        int previousIndex = 0;
        int currentIndex = name.indexOf("_");
        while (previousIndex > -1 && currentIndex > -1) {
            if (currentIndex - previousIndex > minSize + 1) {
                result.append(name.substring(previousIndex, currentIndex - 1));
                ++charsRemoved;
                allMinSizeOrLess = allMinSizeOrLess && currentIndex - previousIndex <= minSize;
            } else {
                result.append(name.substring(previousIndex, currentIndex));
            }
            if (name.length() - charsRemoved <= length) {
                allMinSizeOrLess = false;
                previousIndex = currentIndex;
                break;
            }
            previousIndex = currentIndex;
            currentIndex = name.indexOf("_", currentIndex + 1);
        }
        result.append(name.substring(previousIndex));
        String finalResult = result.toString();
        if (allMinSizeOrLess) {
            result.setLength(length);
            finalResult = result.toString();
        } else if (finalResult.length() > length) {
            finalResult = Constraint.abbreviate(result.toString(), length);
        }
        return finalResult;
    }

    public Table getTable() {
        return this.m_table;
    }

    public String getName() {
        if (this.m_name == null) {
            this.m_name = this.generateName();
        }
        return this.m_name;
    }

    public Column[] getColumns() {
        return this.m_columns;
    }

    public abstract boolean isDeferred();

    abstract String getSuffix();

    abstract String getColumnSQL();

    public abstract String getSQL();

    String getColumnList() {
        return this.getColumnList(false);
    }

    String getColumnList(boolean sort) {
        ArrayList<Column> cols = sort ? this.getSortedColumns() : new ArrayList<Column>(Arrays.asList(this.m_columns));
        StringBuffer result = new StringBuffer("(");
        Iterator it = cols.iterator();
        while (it.hasNext()) {
            Column col = (Column)it.next();
            result.append(col.getName());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append(")");
        return result.toString();
    }

    List getSortedColumns() {
        ArrayList<Column> cols = new ArrayList<Column>(Arrays.asList(this.m_columns));
        Collections.sort(cols, new Comparator(){

            public int compare(Object o1, Object o2) {
                Column c1 = (Column)o1;
                Column c2 = (Column)o2;
                return c1.getName().compareTo(c2.getName());
            }
        });
        return cols;
    }

    public String toString() {
        return this.getSQL();
    }
}

