/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.engine.rdbms;

import com.redhat.persistence.AddEvent;
import com.redhat.persistence.CreateEvent;
import com.redhat.persistence.DeleteEvent;
import com.redhat.persistence.Event;
import com.redhat.persistence.ObjectEvent;
import com.redhat.persistence.PropertyEvent;
import com.redhat.persistence.RemoveEvent;
import com.redhat.persistence.SetEvent;
import com.redhat.persistence.common.CompoundKey;
import com.redhat.persistence.engine.rdbms.Node;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

class Aggregator
extends Event.Switch {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/engine/rdbms/Aggregator.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger LOG = Logger.getLogger((Class)(class$com$redhat$persistence$engine$rdbms$Aggregator == null ? (class$com$redhat$persistence$engine$rdbms$Aggregator = Aggregator.class$("com.redhat.persistence.engine.rdbms.Aggregator")) : class$com$redhat$persistence$engine$rdbms$Aggregator));
    private ArrayList m_nodes = new ArrayList();
    private EventMap m_objects = new EventMap();
    private EventMap m_properties = new EventMap();
    private EventMap m_depending = new EventMap();
    private EventMap m_violations = new EventMap();
    private EventMap m_twoWay = new EventMap();
    private EventMap m_attributes = new EventMap();
    static /* synthetic */ Class class$com$redhat$persistence$engine$rdbms$Aggregator;
    static /* synthetic */ Class class$java$util$Collection;

    Aggregator() {
    }

    public Collection getNodes() {
        return this.m_nodes;
    }

    private Event getObjectEvent(Object obj) {
        return this.m_objects.getEvent(obj);
    }

    private void setObjectEvent(Object obj, Event ev) {
        this.m_objects.setEvent(obj, ev);
    }

    private Event getPropertyEvent(Object obj, Property prop) {
        return this.m_properties.getEvent(new CompoundKey(obj, prop));
    }

    private void setPropertyEvent(Object obj, Property prop, Event ev) {
        this.m_properties.setEvent(new CompoundKey(obj, prop), ev);
    }

    private Event getPropertyEvent(Object obj, Property prop, Object arg) {
        return this.m_properties.getEvent(new CompoundKey(obj, new CompoundKey(prop, arg)));
    }

    private void setPropertyEvent(Object obj, Property prop, Object arg, Event ev) {
        this.m_properties.setEvent(new CompoundKey(obj, new CompoundKey(prop, arg)), ev);
    }

    private void addDependingEvent(Object obj, Event ev) {
        this.m_depending.addEvent(obj, ev);
    }

    private Collection getDependingEvents(Object obj) {
        return this.m_depending.getEvents(obj);
    }

    private Node findNode(Event ev) {
        Iterator it = this.m_nodes.iterator();
        while (it.hasNext()) {
            Node nd = (Node)it.next();
            if (!nd.getEvents().contains(ev)) continue;
            return nd;
        }
        throw new IllegalArgumentException("event not in any node: " + ev);
    }

    private Node merge(Node to, Node from, String msg) {
        if (to == from) {
            return to;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Merging[" + msg + "]\n\n" + from + "\n\ninto\n\n" + to + "\n\n"));
        }
        if (!this.m_nodes.contains(to)) {
            throw new IllegalArgumentException("merging into nonexistent node\nto = " + to + "\nfrom = " + from);
        }
        if (!this.m_nodes.contains(from)) {
            throw new IllegalArgumentException("merging from nonexistent node\nto = " + to + "\n from = " + from);
        }
        to.merge(from);
        this.m_nodes.remove(from);
        return to;
    }

    private Event getViolation(Object obj, Property prop) {
        return this.m_violations.getEvent(new CompoundKey(obj, prop));
    }

    private void setViolation(Object obj, Property prop, Event ev) {
        this.m_violations.setEvent(new CompoundKey(obj, prop), ev);
    }

    private void clearViolation(Object obj, Property prop) {
        this.m_violations.remove(new CompoundKey(obj, prop));
    }

    private void setTwoWayEvent(Object obj, Property prop, Object arg, Event ev) {
        this.m_twoWay.setEvent(new CompoundKey(obj, new CompoundKey(prop, arg)), ev);
    }

    private Event getTwoWayEvent(Object obj, Property prop, Object arg) {
        return this.m_twoWay.getEvent(new CompoundKey(obj, new CompoundKey(prop, arg)));
    }

    private void setAttributeEvent(Object obj, Event ev) {
        this.m_attributes.setEvent(obj, ev);
    }

    private Event getAttributeEvent(Object obj) {
        return this.m_attributes.getEvent(obj);
    }

    private void clearAttributeNode(Object obj) {
        this.m_attributes.remove(obj);
    }

    private Node onEvent(Event e) {
        Node nd = new Node();
        nd.addEvent(e);
        this.m_nodes.add(nd);
        nd.addDependency(this.getObjectEvent(e.getObject()));
        return nd;
    }

    private Node onObjectEvent(ObjectEvent e) {
        Node nd = this.onEvent(e);
        this.setObjectEvent(e.getObject(), e);
        return nd;
    }

    public void onCreate(CreateEvent e) {
        Node nd = this.onObjectEvent(e);
        Object obj = e.getObject();
        Collection roles = e.getObjectMap().getObjectType().getRoles();
        Iterator it = roles.iterator();
        while (it.hasNext()) {
            Role role = (Role)it.next();
            if (role.isNullable()) continue;
            this.setViolation(obj, role, e);
        }
        this.setAttributeEvent(obj, e);
    }

    public void onDelete(DeleteEvent e) {
        Node nd = this.onObjectEvent(e);
        Object obj = e.getObject();
        nd.addDependencies(this.getDependingEvents(obj));
        Collection roles = e.getObjectMap().getObjectType().getRoles();
        Iterator it = roles.iterator();
        while (it.hasNext()) {
            Role role = (Role)it.next();
            Event vile = this.getViolation(obj, role);
            if (vile == null) continue;
            nd = this.merge(nd, this.findNode(vile), "violations from delete");
            this.clearViolation(obj, role);
        }
        Event attr = this.getAttributeEvent(obj);
        if (attr != null) {
            nd = this.merge(nd, this.findNode(attr), "attributes from delete");
        }
        this.clearAttributeNode(obj);
    }

    private Node onPropertyEvent(PropertyEvent e) {
        Node nd = this.onEvent(e);
        Object arg = e.getArgument();
        nd.addDependency(this.getObjectEvent(arg));
        Object obj = e.getObject();
        Property prop = e.getProperty();
        Event prev = prop.isCollection() ? this.getPropertyEvent(obj, prop, arg) : this.getPropertyEvent(obj, prop);
        nd.addDependency(prev);
        if (prop.isCollection()) {
            this.setPropertyEvent(obj, prop, arg, e);
        } else {
            this.setPropertyEvent(obj, prop, e);
        }
        this.addDependingEvent(obj, e);
        if (arg != null) {
            this.addDependingEvent(arg, e);
        }
        return nd;
    }

    private Node mergeTwoWay(Node nd, Object obj, Property prop, Object arg, String msg) {
        Role role = (Role)prop;
        if (!role.isReversable()) {
            return nd;
        }
        Role rev = role.getReverse();
        Node result = nd;
        Event ev = this.getTwoWayEvent(obj, prop, arg);
        if (ev != null) {
            result = this.merge(this.findNode(ev), result, msg + " (forward)");
        }
        if ((ev = this.getTwoWayEvent(arg, rev, obj)) != null) {
            result = this.merge(this.findNode(ev), result, msg + " (reverse)");
        }
        return result;
    }

    public void onSet(SetEvent e) {
        Event vile;
        Node nd = this.onPropertyEvent(e);
        Object prev = e.getPreviousValue();
        nd.addDependency(this.getObjectEvent(prev));
        if (prev != null) {
            this.addDependingEvent(prev, e);
        }
        Object obj = e.getObject();
        Property prop = e.getProperty();
        Object arg = e.getArgument();
        if (prev != null) {
            nd = this.mergeTwoWay(nd, obj, prop, prev, "two way previous value from set");
        }
        if (arg != null) {
            nd = this.mergeTwoWay(nd, obj, prop, arg, "two way arg from set");
        }
        if ((vile = this.getViolation(obj, prop)) != null) {
            nd = this.merge(this.findNode(vile), nd, "violation from set");
            if (arg != null) {
                this.clearViolation(obj, prop);
            }
        }
        if (!prop.getType().isKeyed()) {
            Event attr = this.getAttributeEvent(obj);
            if (attr == null) {
                this.setAttributeEvent(obj, e);
            } else {
                nd = this.merge(this.findNode(attr), nd, "attributes from set");
            }
        }
        if (!prop.isNullable() && arg == null) {
            this.setViolation(obj, prop, e);
        }
        if (prev != null) {
            this.setTwoWayEvent(obj, prop, prev, e);
        }
        if (arg != null) {
            this.setTwoWayEvent(obj, prop, arg, e);
        }
    }

    public void onAdd(AddEvent e) {
        Node nd = this.onPropertyEvent(e);
        nd = this.mergeTwoWay(nd, e.getObject(), e.getProperty(), e.getArgument(), "two way from add");
        this.setTwoWayEvent(e.getObject(), e.getProperty(), e.getArgument(), e);
    }

    public void onRemove(RemoveEvent e) {
        Node nd = this.onPropertyEvent(e);
        nd = this.mergeTwoWay(nd, e.getObject(), e.getProperty(), e.getArgument(), "two way from remove");
        this.setTwoWayEvent(e.getObject(), e.getProperty(), e.getArgument(), e);
    }

    public void clear() {
        this.m_nodes.clear();
        this.m_objects.clear();
        this.m_properties.clear();
        this.m_depending.clear();
        this.m_violations.clear();
        this.m_twoWay.clear();
        this.m_attributes.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class EventMap
    extends HashMap {
        private EventMap() {
        }

        public Event getEvent(Object key) {
            return (Event)this.get(key);
        }

        public void setEvent(Object key, Event ev) {
            this.put(key, ev);
        }

        public Collection getEvents(Object key) {
            return this.getEvents(key, false);
        }

        private Collection getEvents(Object key, boolean create) {
            key = new CompoundKey(class$java$util$Collection == null ? (class$java$util$Collection = Aggregator.class$("java.util.Collection")) : class$java$util$Collection, key);
            ArrayList result = (ArrayList)this.get(key);
            if (result == null && create) {
                result = new ArrayList();
                this.put(key, result);
            }
            return result;
        }

        private void addEvent(Object key, Event ev) {
            Collection events = this.getEvents(key, true);
            if (!events.contains(ev)) {
                events.add(ev);
            }
        }
    }
}

