/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.NoSuchPathException;
import com.redhat.persistence.Source;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class Signature {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/Signature.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$redhat$persistence$Signature == null ? (class$com$redhat$persistence$Signature = Signature.class$("com.redhat.persistence.Signature")) : class$com$redhat$persistence$Signature));
    private ArrayList m_paths = new ArrayList();
    private ArrayList m_sources = new ArrayList();
    private HashMap m_sourceMap = new HashMap();
    static /* synthetic */ Class class$com$redhat$persistence$Signature;

    public Signature() {
    }

    public Signature(Signature sig) {
        this.m_paths.addAll(sig.m_paths);
        this.m_sources.addAll(sig.m_sources);
        this.m_sourceMap.putAll(sig.m_sourceMap);
    }

    public Signature(ObjectType type) {
        this.addSource(type, null);
    }

    public Query makeQuery(Expression expr) {
        this.addDefaultProperties();
        if (this.m_paths.size() == 0) {
            throw new IllegalStateException(this + "\n");
        }
        Query q = new Query(expr);
        Iterator it = this.m_paths.iterator();
        while (it.hasNext()) {
            Path path = (Path)it.next();
            if (path == null) continue;
            q.fetch(this.getColumn(path), Expression.valueOf(path));
        }
        return q;
    }

    public String getColumn(Path p) {
        int pathIdxWidth;
        int size = 30;
        String path = p.getPath();
        if (path.length() <= 30) {
            return path;
        }
        int pathIndex = this.m_paths.indexOf(p);
        if (pathIndex == 0) {
            pathIdxWidth = 1;
        } else {
            pathIdxWidth = 0;
            for (int i = pathIndex; i > 0; i /= 10) {
                ++pathIdxWidth;
            }
        }
        StringBuffer result = new StringBuffer(30);
        result.append(path.substring(0, 30 - pathIdxWidth));
        result.append(pathIndex);
        return result.toString();
    }

    public ObjectType getObjectType() {
        return this.getSource(null).getObjectType();
    }

    public boolean hasPath(Path p) {
        return this.m_paths.contains(p);
    }

    public void addPath(String path) {
        this.addPath(Path.get(path));
    }

    private void addPathImmediates(Path path) {
        ObjectType type = this.getType(path);
        List props = type.getImmediateProperties();
        if (props.size() == 0 && !this.isSource(path)) {
            if (!this.m_paths.contains(path)) {
                this.m_paths.add(path);
            }
        } else {
            Iterator it = props.iterator();
            while (it.hasNext()) {
                Property prop = (Property)it.next();
                this.addPathImmediates(Path.add(path, prop.getName()));
            }
        }
    }

    private void makePathLoadable(Path prefix, Collection paths) {
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            Path p = (Path)it.next();
            Path path = prefix == null ? p : Path.add(prefix, p);
            this.makePathLoadable(path);
        }
    }

    private void makePathLoadable(Path path) {
        Path parent;
        this.addPathImmediates(path);
        if (!this.isSource(path) && !this.m_paths.contains(parent = path.getParent())) {
            this.makePathLoadable(parent);
        }
    }

    public void addPath(Path path) {
        if (!this.exists(path)) {
            throw new NoSuchPathException(path);
        }
        if (path == null) {
            return;
        }
        this.makePathLoadable(path);
        this.addDefaultProperties(path);
    }

    public Collection getPaths() {
        return this.m_paths;
    }

    public boolean isFetched(Path path) {
        if (path == null) {
            return true;
        }
        Iterator it = this.getPaths().iterator();
        while (it.hasNext()) {
            Path p = (Path)it.next();
            if (!path.isAncestor(p)) continue;
            return true;
        }
        return false;
    }

    public void addSignature(Signature sig, Path path) {
        Iterator it = sig.m_sources.iterator();
        while (it.hasNext()) {
            Source source = (Source)it.next();
            this.addSource(source.getObjectType(), Path.add(path, source.getPath()));
        }
        it = sig.m_paths.iterator();
        while (it.hasNext()) {
            Path p = Path.add(path, (Path)it.next());
            if (this.m_paths.contains(p)) continue;
            this.m_paths.add(p);
        }
    }

    public void addSource(ObjectType type, Path path) {
        this.addSource(new Source(type, path));
    }

    public void addSource(Source s) {
        if (s == null) {
            throw new IllegalArgumentException("Cannot add a null source.");
        }
        if (this.m_sourceMap.containsKey(s.getPath())) {
            throw new IllegalArgumentException("Query already contains a source for that path: " + s.getPath());
        }
        this.m_sources.add(s);
        this.m_sourceMap.put(s.getPath(), s);
    }

    public Source getSource(Path p) {
        if (this.isSource(p)) {
            return (Source)this.m_sourceMap.get(p);
        }
        return null;
    }

    public boolean isSource(Path p) {
        return this.m_sourceMap.containsKey(p);
    }

    public Collection getSources() {
        return this.m_sources;
    }

    private void addPathImmediates(Path prefix, Collection paths) {
        Iterator it = paths.iterator();
        while (it.hasNext()) {
            Path p = (Path)it.next();
            Path path = prefix == null ? p : Path.add(prefix, p);
            this.addPathImmediates(path);
        }
    }

    private void addDefaultProperties(Path path) {
        Property prop;
        Root root;
        ObjectMap container;
        ObjectType type = this.getType(path);
        this.addFetchedPaths(path, type);
        if (!this.isSource(path) && (container = (root = type.getRoot()).getObjectMap((prop = this.getProperty(path)).getContainer())) != null) {
            this.makePathLoadable(path.getParent(), container.getDeclaredFetchedPaths());
        }
    }

    private void addFetchedPaths(Path path, ObjectType type) {
        Root root = type.getRoot();
        if (root == null) {
            return;
        }
        ObjectMap om = root.getObjectMap(type);
        this.makePathLoadable(path, om.getFetchedPaths());
    }

    private void addDefaultProperties() {
        Iterator it = this.m_sources.iterator();
        while (it.hasNext()) {
            Source source = (Source)it.next();
            this.makePathLoadable(source.getPath());
            this.addFetchedPaths(source.getPath(), source.getObjectType());
        }
    }

    public Property getProperty(Path path) {
        Path parent = path.getParent();
        if (this.isSource(parent)) {
            return this.getSource(parent).getObjectType().getProperty(path.getName());
        }
        Property prop = this.getProperty(parent);
        if (prop == null) {
            throw new IllegalArgumentException("no such property in signature: " + path);
        }
        return prop.getType().getProperty(path.getName());
    }

    public ObjectType getType(Path path) {
        if (this.isSource(path)) {
            return this.getSource(path).getObjectType();
        }
        return this.getProperty(path).getType();
    }

    public boolean exists(Path p) {
        if (this.isSource(p)) {
            return true;
        }
        if (p == null) {
            return false;
        }
        return this.exists(p.getParent()) && this.getType(p.getParent()).getProperty(p.getName()) != null;
    }

    public String toString() {
        return "Paths are  " + this.m_paths + ", sources are " + this.m_sources;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

