/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence;

import com.redhat.persistence.Event;
import com.redhat.persistence.ObjectEvent;
import com.redhat.persistence.PropertyData;
import com.redhat.persistence.Session;
import com.redhat.persistence.metadata.Property;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

class ObjectData {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/ObjectData.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger LOG = Logger.getLogger((Class)(class$com$redhat$persistence$ObjectData == null ? (class$com$redhat$persistence$ObjectData = ObjectData.class$("com.redhat.persistence.ObjectData")) : class$com$redhat$persistence$ObjectData));
    private final Session m_ssn;
    private Object m_object;
    public static final State INFANTILE = new State("infantile");
    public static final State NUBILE = new State("nubile");
    public static final State AGILE = new State("agile");
    public static final State SENILE = new State("senile");
    public static final State DEAD = new State("dead");
    private boolean m_startedNew = false;
    private State m_state;
    private HashMap m_pdata = new HashMap();
    static /* synthetic */ Class class$com$redhat$persistence$ObjectData;

    public ObjectData(Session ssn, Object object, State state) {
        this.m_ssn = ssn;
        this.m_object = object;
        this.setState(state);
        this.m_ssn.addObjectData(this);
    }

    public Session getSession() {
        return this.m_ssn;
    }

    public Object getObject() {
        return this.m_object;
    }

    void setObject(Object object) {
        this.m_object = object;
    }

    public void addPropertyData(Property p, PropertyData pd) {
        this.m_pdata.put(p, pd);
    }

    public PropertyData getPropertyData(Property prop) {
        return (PropertyData)this.m_pdata.get(prop);
    }

    public boolean hasPropertyData(Property prop) {
        return this.m_pdata.containsKey(prop);
    }

    public boolean isNew() {
        return this.m_startedNew;
    }

    public boolean isDeleted() {
        return this.isDead() || this.isSenile();
    }

    public boolean isModified() {
        return !this.isNubile();
    }

    public boolean isInfantile() {
        return this.m_state.equals(INFANTILE);
    }

    public boolean isNubile() {
        return this.m_state.equals(NUBILE);
    }

    public boolean isAgile() {
        return this.m_state.equals(AGILE);
    }

    public boolean isSenile() {
        return this.m_state.equals(SENILE);
    }

    public boolean isDead() {
        return this.m_state.equals(DEAD);
    }

    public boolean isFlushed() {
        if (this.getSession().getEventStream().getLastEvent(this.getObject()) != null) {
            return false;
        }
        Iterator it = this.m_pdata.values().iterator();
        while (it.hasNext()) {
            PropertyData pdata = (PropertyData)it.next();
            if (pdata.isFlushed()) continue;
            return false;
        }
        return true;
    }

    void setState(State state) {
        if (state.equals(INFANTILE)) {
            this.m_startedNew = true;
        }
        this.m_state = state;
    }

    public State getState() {
        return this.m_state;
    }

    void dump() {
        PrintWriter pw = new PrintWriter(System.out);
        this.dump(pw);
        pw.flush();
    }

    void dump(PrintWriter out) {
        out.println("    object = " + this.getObject());
        Iterator it = this.m_pdata.values().iterator();
        while (it.hasNext()) {
            PropertyData pdata = (PropertyData)it.next();
            pdata.dump(out);
        }
        ObjectEvent ev = this.getSession().getEventStream().getLastEvent(this.getObject());
        if (ev != null) {
            out.println("    Current Object Event:");
            ((Event)ev).dump(out);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class State {
        private String m_name;

        private State(String name) {
            this.m_name = name;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

