/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.xml;

import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Document {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/xml/Document.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$xml$Document == null ? (class$com$arsdigita$xml$Document = Document.class$("com.arsdigita.xml.Document")) : class$com$arsdigita$xml$Document).getName());
    private static final String identityXSL = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n<xsl:output method=\"xml\"/>\n<xsl:template match=\"text()|comment()|processing-instruction()\">\n  <xsl:copy/>\n</xsl:template>\n<xsl:template match=\"*\">\n  <xsl:element name=\"{name()}\" namespace=\"{namespace-uri()}\"><xsl:apply-templates select=\"node()|@*\"/></xsl:element>\n</xsl:template>\n<xsl:template match=\"@*\">\n  <xsl:attribute name=\"{name()}\" namespace=\"{namespace-uri()}\"><xsl:value-of select=\".\"/></xsl:attribute>\n</xsl:template>\n<xsl:template match=\"bebop:structure\"  xmlns:bebop=\"http://www.arsdigita.com/bebop/1.0\">\n</xsl:template>\n</xsl:stylesheet>";
    protected static DocumentBuilderFactory s_builder = null;
    protected static ThreadLocal s_db = null;
    protected org.w3c.dom.Document m_document;
    static /* synthetic */ Class class$com$arsdigita$xml$Document;

    public Document() throws ParserConfigurationException {
        DocumentBuilder db = (DocumentBuilder)s_db.get();
        if (db == null) {
            throw new ParserConfigurationException("Unable to create a DocumentBuilder");
        }
        this.m_document = db.newDocument();
    }

    public Document(org.w3c.dom.Document doc) {
        this.m_document = doc;
    }

    public Document(Element rootNode) throws ParserConfigurationException {
        DocumentBuilder db = (DocumentBuilder)s_db.get();
        if (db == null) {
            throw new ParserConfigurationException("Unable to create a DocumentBuilder");
        }
        this.m_document = db.newDocument();
        rootNode.importInto(this.m_document);
        this.m_document.appendChild(rootNode.getInternalElement());
    }

    public Document(String xmlString) throws ParserConfigurationException, SAXException {
        this(new InputSource(new StringReader(xmlString)));
    }

    public Document(byte[] xmlBytes) throws ParserConfigurationException, SAXException {
        this(new InputSource(new ByteArrayInputStream(xmlBytes)));
    }

    private Document(InputSource inputSource) throws ParserConfigurationException, SAXException {
        org.w3c.dom.Document domDoc;
        DocumentBuilder db = (DocumentBuilder)s_db.get();
        if (db == null) {
            throw new ParserConfigurationException("Unable to create a DocumentBuilder");
        }
        try {
            domDoc = db.parse(inputSource);
        }
        catch (IOException e) {
            throw new UncheckedWrapperException(e);
        }
        this.m_document = domDoc;
    }

    public Document setRootElement(Element rootNode) {
        rootNode.importInto(this.m_document);
        this.m_document.appendChild(rootNode.getInternalElement());
        return this;
    }

    public Element createRootElement(String elt, String ns) {
        org.w3c.dom.Element root = this.m_document.createElementNS(ns, elt);
        this.m_document.appendChild(root);
        Element wrapper = new Element();
        wrapper.m_element = root;
        return wrapper;
    }

    public Element createRootElement(String elt) {
        org.w3c.dom.Element root = this.m_document.createElement(elt);
        this.m_document.appendChild(root);
        Element wrapper = new Element();
        wrapper.m_element = root;
        return wrapper;
    }

    public Element getRootElement() {
        Element root = new Element();
        root.m_element = this.m_document.getDocumentElement();
        return root;
    }

    public org.w3c.dom.Document getInternalDocument() {
        return this.m_document;
    }

    public static String toString(org.w3c.dom.Document document, boolean indent) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            StreamSource identitySource = new StreamSource(new StringReader(identityXSL));
            Transformer identity = TransformerFactory.newInstance().newTransformer(identitySource);
            identity.setOutputProperty("method", "xml");
            identity.setOutputProperty("indent", indent ? "yes" : "no");
            identity.setOutputProperty("encoding", "UTF-8");
            identity.transform(new DOMSource(document), new StreamResult(os));
        }
        catch (TransformerException e) {
            s_log.error((Object)"error in toString", (Throwable)e);
            return document.toString();
        }
        try {
            return os.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            s_log.error((Object)"UTF-8 encoding not supported!!!");
            return os.toString();
        }
    }

    public static String toString(org.w3c.dom.Document document) {
        return Document.toString(document, false);
    }

    public String toString(boolean indent) {
        return Document.toString(this.m_document, indent);
    }

    public String toString() {
        return Document.toString(this.m_document, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_builder = DocumentBuilderFactory.newInstance();
        s_builder.setNamespaceAware(true);
        s_db = new ThreadLocal(){

            public Object initialValue() {
                try {
                    return s_builder.newDocumentBuilder();
                }
                catch (ParserConfigurationException pce) {
                    return null;
                }
            }
        };
    }
}

