/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.webdevsupport;

import com.arsdigita.dispatcher.RequestEvent;
import com.arsdigita.webdevsupport.QueryInfo;
import com.arsdigita.webdevsupport.StageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class RequestInfo {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/webdevsupport/RequestInfo.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static int s_counter = 1;
    private int m_id = RequestInfo.nextID();
    private Date m_start = new Date();
    private Date m_end = null;
    private HashMap m_headers = new HashMap();
    private HashMap m_parameters = new HashMap();
    private HashMap m_properties = new HashMap();
    private List m_comments = new ArrayList();
    private List m_queries = new ArrayList();
    private int m_stage_depth = 0;
    private List m_stages = new ArrayList();
    private StageInfo m_last_stage = null;

    private static synchronized int nextID() {
        return s_counter++;
    }

    public RequestInfo(RequestEvent re) {
        HttpServletRequest req = re.getRequest();
        this.addProperty("METHOD", req.getMethod());
        this.addProperty("QUERY", req.getQueryString());
        this.addProperty("IP", req.getRemoteAddr());
        this.addProperty("URL", req.getRequestURI());
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String header = (String)e.nextElement();
            this.m_headers.put(header, req.getHeader(header));
        }
        e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String param = (String)e.nextElement();
            this.m_parameters.put(param, req.getParameter(param));
        }
    }

    public Iterator getParameterNames() {
        return this.m_parameters.keySet().iterator();
    }

    public String getParameter(String name) {
        return (String)this.m_parameters.get(name);
    }

    public void finish() {
        this.m_end = new Date();
        for (int i = 0; i < this.m_stages.size(); ++i) {
            StageInfo si = (StageInfo)this.m_stages.get(i);
            if (si.endTime() != 0L) continue;
            si.end(this.numQueries());
        }
    }

    public String getTime() {
        return this.m_start.toString();
    }

    public String getEndTime() {
        if (this.m_end != null) {
            return this.m_end.toString();
        }
        return "<none>";
    }

    public String getDuration() {
        if (this.m_end == null) {
            return "";
        }
        return this.m_end.getTime() - this.m_start.getTime() + "";
    }

    public String getIP() {
        return (String)this.getProperty("IP");
    }

    public String getURL() {
        return (String)this.getProperty("URL");
    }

    public String getRequest() {
        String query = this.getQuery();
        if (query == null) {
            return this.getMethod() + " " + this.getURL();
        }
        return this.getMethod() + " " + this.getURL() + "?" + this.getQuery();
    }

    public String getMethod() {
        return (String)this.getProperty("METHOD");
    }

    public String getQuery() {
        return (String)this.getProperty("QUERY");
    }

    public int getID() {
        return this.m_id;
    }

    public Iterator headerKeys() {
        return this.m_headers.keySet().iterator();
    }

    public String getHeader(String key) {
        return (String)this.m_headers.get(key);
    }

    public void addProperty(String property, Object value) {
        this.m_properties.put(property, value);
    }

    public Set propertyKeys() {
        return this.m_properties.keySet();
    }

    public Object getProperty(String key) {
        return this.m_properties.get(key);
    }

    public void logComment(String comment) {
        this.m_comments.add(comment);
    }

    public ListIterator getComments() {
        return this.m_comments.listIterator();
    }

    public int numComments() {
        return this.m_comments.size();
    }

    public void logQuery(QueryInfo qi) {
        this.m_queries.add(qi);
    }

    public ListIterator getQueries() {
        return this.m_queries.listIterator();
    }

    public QueryInfo getQuery(int id) {
        ListIterator iter = this.getQueries();
        while (iter.hasNext()) {
            QueryInfo qi = (QueryInfo)iter.next();
            if (qi.getID() != id) continue;
            return qi;
        }
        return null;
    }

    public int numQueries() {
        return this.m_queries.size();
    }

    public int getNumQueries() {
        return this.numQueries();
    }

    public boolean isDevSupportRequest() {
        return this.getProperty("IS_DS") != null;
    }

    public void startStage(String stagename) {
        if (this.m_last_stage != null) {
            this.m_last_stage.setLeaf(false);
        }
        this.m_last_stage = new StageInfo(stagename, this.m_stage_depth++, this.numQueries());
        this.m_stages.add(this.m_last_stage);
    }

    public void endStage(String stagename) {
        for (int i = this.m_stages.size() - 1; i >= 0; --i) {
            StageInfo si = (StageInfo)this.m_stages.get(i);
            if (!si.getName().equals(stagename)) continue;
            si.end(this.numQueries());
        }
        this.m_last_stage = null;
        --this.m_stage_depth;
    }

    public int numStages() {
        return this.m_stages.size();
    }

    public ListIterator getStages() {
        return this.m_stages.listIterator();
    }
}

