/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web.ui;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.kernel.Resource;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationType;

public class ApplicationConfigFormSection
extends ResourceConfigFormSection {
    private RequestLocal m_parentResource;
    private RequestLocal m_currentResource;
    private ApplicationType m_applicationType;
    private TextField m_url;
    private TextField m_title;
    private TextArea m_desc;

    public ApplicationConfigFormSection(ResourceType resType, RequestLocal parentAppRL) {
        this.m_applicationType = (ApplicationType)resType;
        this.m_parentResource = parentAppRL;
        this.m_applicationType.disconnect();
        this.setup();
    }

    public ApplicationConfigFormSection(RequestLocal application) {
        this.m_currentResource = application;
        this.setup();
    }

    private void setup() {
        this.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                if (ApplicationConfigFormSection.this.m_currentResource != null) {
                    Application application = (Application)ApplicationConfigFormSection.this.m_currentResource.get(state);
                    ApplicationConfigFormSection.this.initWidgets(state, application);
                } else {
                    ApplicationConfigFormSection.this.initWidgets(state, null);
                }
            }
        });
        this.addValidationListener(new FormValidationListener(){

            public void validate(FormSectionEvent e) throws FormProcessException {
                PageState state = e.getPageState();
                if (ApplicationConfigFormSection.this.m_currentResource != null) {
                    Application application = (Application)ApplicationConfigFormSection.this.m_currentResource.get(state);
                    ApplicationConfigFormSection.this.validateWidgets(state, application);
                } else {
                    ApplicationConfigFormSection.this.validateWidgets(state, null);
                }
            }
        });
        this.addWidgets();
    }

    protected void addWidgets() {
        this.m_url = new TextField(new StringParameter("url"));
        this.m_url.setSize(35);
        this.m_url.addValidationListener(new NotNullValidationListener());
        this.m_url.addValidationListener(new StringInRangeValidationListener(1, 30));
        this.m_title = new TextField(new StringParameter("title"));
        this.m_title.setSize(35);
        this.m_title.addValidationListener(new NotNullValidationListener());
        this.m_title.addValidationListener(new StringInRangeValidationListener(1, 200));
        this.m_desc = new TextArea(new StringParameter("desc"));
        this.m_desc.setRows(5);
        this.m_desc.setCols(35);
        this.m_desc.addValidationListener(new StringInRangeValidationListener(0, 4000));
        this.add(new Label("URL:", "b"), 4);
        this.add(this.m_url);
        this.add(new Label("Title:", "b"), 4);
        this.add(this.m_title);
        this.add(new Label("Description:", "b"), 4);
        this.add(this.m_desc);
    }

    protected void initWidgets(PageState state, Application application) throws FormProcessException {
        if (application != null) {
            String path = application.getPath();
            String url = path.substring(path.lastIndexOf("/") + 1);
            this.m_url.setValue(state, url);
            this.m_title.setValue(state, application.getTitle());
            this.m_desc.setValue(state, application.getDescription());
        } else {
            this.m_url.setValue(state, null);
            this.m_title.setValue(state, this.m_applicationType.getTitle());
            this.m_desc.setValue(state, this.m_applicationType.getDescription());
        }
    }

    protected void validateWidgets(PageState state, Application application) throws FormProcessException {
        String url = (String)this.m_url.getValue(state);
        if (url.indexOf("/") != -1) {
            throw new FormProcessException("The url cannot contain '/'");
        }
        Application parent = (Application)this.m_parentResource.get(state);
        if (parent != null) {
            String path = parent.getPath() + "/" + url;
        } else {
            String path = url;
        }
        if (Application.isInstalled("com.arsdigita.web.Application", url)) {
            throw new FormProcessException("An application already exists with that name");
        }
    }

    public Resource createResource(PageState state) {
        Application parent = (Application)this.m_parentResource.get(state);
        Application application = Application.createApplication(this.m_applicationType, (String)this.m_url.getValue(state), (String)this.m_title.getValue(state), parent);
        try {
            this.processWidgets(state, application);
        }
        catch (FormProcessException ex) {
            throw new UncheckedWrapperException("cannot create resource", (Throwable)((Object)ex));
        }
        return application;
    }

    public void modifyResource(PageState state) {
        Application application = (Application)this.m_currentResource.get(state);
        try {
            this.processWidgets(state, application);
        }
        catch (FormProcessException ex) {
            throw new UncheckedWrapperException("cannot create resource", (Throwable)((Object)ex));
        }
    }

    protected void processWidgets(PageState state, Application application) throws FormProcessException {
        application.setTitle((String)this.m_title.getValue(state));
        application.setDescription((String)this.m_desc.getValue(state));
    }
}

