/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.InternalRequestLocal;
import com.arsdigita.web.WebConfig;
import com.arsdigita.web.WebContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class Web {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/Web.java#12 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    public static final String ROOT_WEBAPP = "ROOT";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$Web == null ? (class$com$arsdigita$web$Web = Web.class$("com.arsdigita.web.Web")) : class$com$arsdigita$web$Web));
    private static final ThreadLocal s_request = new InternalRequestLocal();
    private static final ThreadLocal s_servletContext = new InternalRequestLocal();
    private static final ThreadLocal s_userContext = new InternalRequestLocal();
    private static final Map s_contexts = new HashMap();
    static final WebContext s_initialContext = new WebContext();
    private static final ThreadLocal s_context = new WebContextLocal();
    private static final WebConfig s_config = new WebConfig();
    static /* synthetic */ Class class$com$arsdigita$web$Web;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$ServletContext;
    static /* synthetic */ Class class$com$arsdigita$kernel$security$UserContext;

    static final void init(HttpServletRequest sreq, ServletContext sc, UserContext uc) {
        Assert.exists(sreq, class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = Web.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest);
        Assert.exists(sc, class$javax$servlet$ServletContext == null ? (class$javax$servlet$ServletContext = Web.class$("javax.servlet.ServletContext")) : class$javax$servlet$ServletContext);
        Assert.exists(uc, class$com$arsdigita$kernel$security$UserContext == null ? (class$com$arsdigita$kernel$security$UserContext = Web.class$("com.arsdigita.kernel.security.UserContext")) : class$com$arsdigita$kernel$security$UserContext);
        s_request.set(sreq);
        s_servletContext.set(sc);
        s_userContext.set(uc);
    }

    public static final WebContext getContext() {
        return (WebContext)s_context.get();
    }

    public static final WebConfig getConfig() {
        return s_config;
    }

    public static final HttpServletRequest getRequest() {
        return (HttpServletRequest)s_request.get();
    }

    public static final ServletContext getServletContext() {
        return (ServletContext)s_servletContext.get();
    }

    public static final ServletContext getServletContext(String uri) {
        Assert.truth(uri.startsWith("/"), "uri must start with /");
        Assert.truth(uri.endsWith("/"), "uri must end with /");
        return (ServletContext)s_contexts.get(uri);
    }

    static final void registerServletContext(String uri, ServletContext ctx) {
        s_log.debug((Object)("Mapping " + ctx + " to " + uri));
        Assert.truth(s_contexts.get(uri) == null, "a context mapping exists at " + uri);
        s_contexts.put(uri, ctx);
    }

    static final void unregisterServletContext(String uri) {
        s_log.debug((Object)("Unmapping " + uri));
        s_contexts.remove(uri);
    }

    public static final UserContext getUserContext() {
        return (UserContext)s_userContext.get();
    }

    public static URL findResource(String resource) {
        ResourceSpec spec = Web.parseResource(resource);
        return Web.findResource(spec.getWebapps(), spec.getPath());
    }

    public static URL findResource(String[] webapps, String path) {
        ServletContext ctx = Web.findResourceContext(webapps, path);
        URL url = null;
        try {
            url = ctx == null ? null : ctx.getResource(path);
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("cannot get URL for " + path, ex);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("URL for " + path + " is " + url));
        }
        return url;
    }

    public static InputStream findResourceAsStream(String resource) throws IOException {
        ResourceSpec spec = Web.parseResource(resource);
        return Web.findResourceAsStream(spec.getWebapps(), spec.getPath());
    }

    public static InputStream findResourceAsStream(String[] webapps, String path) throws IOException {
        URL url = Web.findResource(webapps, path);
        return url == null ? null : url.openStream();
    }

    public static RequestDispatcher findResourceDispatcher(String resource) {
        ResourceSpec spec = Web.parseResource(resource);
        return Web.findResourceDispatcher(spec.getWebapps(), spec.getPath());
    }

    public static RequestDispatcher findResourceDispatcher(String[] webapps, String path) {
        ServletContext ctx = Web.findResourceContext(webapps, path);
        return ctx == null ? null : ctx.getRequestDispatcher(path);
    }

    private static ServletContext findResourceContext(String[] webapps, String path) {
        for (int i = webapps.length - 1; i >= 0; --i) {
            String ctxPath;
            String string = ctxPath = ROOT_WEBAPP.equals(webapps[i]) ? "" : webapps[i];
            if (!ctxPath.startsWith("/")) {
                ctxPath = "/" + ctxPath;
            }
            if (!ctxPath.endsWith("/")) {
                ctxPath = ctxPath + "/";
            }
            ServletContext ctx = Web.getServletContext(ctxPath);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Servlet context for " + ctxPath + " is " + ctx));
            }
            if (ctx == null) continue;
            try {
                URL url = ctx.getResource(path);
                if (url != null) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Got URL " + url + " for " + path));
                    }
                    return ctx;
                }
                if (!s_log.isDebugEnabled()) continue;
                s_log.debug((Object)("No URL present for " + path));
                continue;
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException("cannot get resource " + path, ex);
            }
        }
        return null;
    }

    private static ResourceSpec parseResource(String resource) {
        if (resource == null || resource.length() < 2) {
            throw new IllegalArgumentException("Resource spec is too short: " + resource);
        }
        int offset = resource.indexOf("/", 1);
        if (offset == -1) {
            throw new IllegalArgumentException("Cannot find second '/' in resource spec : " + resource);
        }
        String webappList = resource.substring(1, offset);
        String path = resource.substring(offset);
        String[] webapps = StringUtils.split(webappList, ',');
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Web app list " + webappList + " path " + path));
        }
        return new ResourceSpec(webapps, path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_config.require("ccm-core/web.properties");
    }

    private static class WebContextLocal
    extends InternalRequestLocal {
        private WebContextLocal() {
        }

        protected Object initialValue() {
            return s_initialContext.copy();
        }

        protected void clearValue() {
            ((WebContext)this.get()).clear();
        }
    }

    private static class ResourceSpec {
        private String[] m_webapps;
        private String m_path;

        public ResourceSpec(String[] webapps, String path) {
            this.m_webapps = webapps;
            this.m_path = path;
        }

        public String[] getWebapps() {
            return this.m_webapps;
        }

        public String getPath() {
            return this.m_path;
        }
    }
}

