/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.kernel.security.Util;
import com.arsdigita.util.Assert;
import com.arsdigita.util.servlet.HttpHost;
import com.arsdigita.web.Application;
import com.arsdigita.web.InternalRequestLocal;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.Web;
import com.arsdigita.web.WebConfig;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class URL {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/URL.java#33 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$URL == null ? (class$com$arsdigita$web$URL = URL.class$("com.arsdigita.web.URL")) : class$com$arsdigita$web$URL));
    private static final String INTERNAL_DIR = "/__ccm__";
    public static final String JSP_DIR = "/__ccm__/jsp";
    public static final String STATIC_DIR = "/__ccm__/static";
    public static final String XSL_DIR = "/__ccm__/xsl";
    public static final String SERVLET_DIR = "/__ccm__/servlet";
    private static final ThreadLocal s_empty = new EmptyParameterMap();
    private StringBuffer m_url;
    private ParameterMap m_params;
    private int m_schemeEnd = -1;
    private int m_serverNameEnd = -1;
    private int m_serverPortEnd = -1;
    private int m_contextPathEnd = -1;
    private int m_servletPathEnd = -1;
    private int m_dispatcherPrefixEnd = -1;
    static /* synthetic */ Class class$com$arsdigita$web$URL;

    private void init(String scheme, String serverName, int serverPort, String contextPath, String servletPath, String dispatcherPrefix, String pathInfo, ParameterMap params) {
        this.m_url = new StringBuffer(96);
        this.m_params = params;
        if (Assert.isAssertEnabled()) {
            Assert.assertNotNull(scheme, "String scheme");
            Assert.assertTrue(!scheme.equals(""), "The scheme cannot be an empty string");
            Assert.assertNotNull(serverName, "String serverName");
            Assert.assertTrue(serverPort > 0, "The serverPort must be greater than 0; I got " + serverPort);
            Assert.assertNotNull(contextPath, "String contextPath");
            if (contextPath.startsWith("/")) {
                Assert.assertTrue(!contextPath.endsWith("/"), "A contextPath starting with '/' must not end in '/'; I got '" + contextPath + "'");
            }
            Assert.assertNotNull(servletPath, "String servletPath");
            if (pathInfo != null) {
                Assert.assertTrue(pathInfo.startsWith("/"), "I expected a pathInfo starting with '/' and got '" + pathInfo + "' instead");
            }
        }
        this.m_url.append(scheme);
        this.m_schemeEnd = this.m_url.length();
        this.m_url.append("://");
        this.m_url.append(serverName);
        this.m_serverNameEnd = this.m_url.length();
        if (serverPort != 80) {
            this.m_url.append(':');
            this.m_url.append(serverPort);
        }
        this.m_serverPortEnd = this.m_url.length();
        this.m_url.append(contextPath);
        this.m_contextPathEnd = this.m_url.length();
        if (dispatcherPrefix != null) {
            this.m_url.append(dispatcherPrefix);
        }
        this.m_dispatcherPrefixEnd = this.m_url.length();
        this.m_url.append(servletPath);
        this.m_servletPathEnd = this.m_url.length();
        if (pathInfo != null) {
            this.m_url.append(pathInfo);
        }
        if (Assert.isAssertEnabled()) {
            Assert.assertTrue(this.m_schemeEnd > -1);
            Assert.assertTrue(this.m_serverNameEnd > -1);
            Assert.assertTrue(this.m_serverPortEnd > -1);
            Assert.assertTrue(this.m_contextPathEnd > -1);
            Assert.assertTrue(this.m_servletPathEnd > -1);
        }
    }

    public URL(String scheme, String serverName, int serverPort, String contextPath, String servletPath, String pathInfo, ParameterMap params) {
        HttpServletRequest req = Web.getRequest();
        String dispatcherPrefix = req == null ? null : DispatcherHelper.getDispatcherPrefix(req);
        this.init(scheme, serverName, serverPort, contextPath, servletPath, dispatcherPrefix, pathInfo, params);
    }

    private URL(HttpServletRequest sreq, ParameterMap params) {
        String dispatcherPrefix = DispatcherHelper.getDispatcherPrefix(sreq);
        HttpHost host = new HttpHost(sreq);
        this.init(sreq.getScheme(), host.getName(), host.getPort(), sreq.getContextPath(), sreq.getServletPath(), dispatcherPrefix, sreq.getPathInfo(), params);
    }

    public URL(HttpServletRequest sreq) {
        this(sreq, new ParameterMap(sreq));
    }

    public final String toDebugString() {
        return super.toString() + " " + "[" + this.getScheme() + "," + this.getServerName() + "," + this.getServerPort() + "," + this.getContextPath() + "," + this.getServletPath() + "," + this.getDispatcherPrefix() + "," + this.getPathInfo() + "," + this.getQueryString() + "]";
    }

    public final String getURL() {
        if (this.m_params == null) {
            return this.m_url.toString();
        }
        return this.m_url.toString() + this.m_params;
    }

    public final String getScheme() {
        return this.m_url.substring(0, this.m_schemeEnd);
    }

    public final String getServerName() {
        return this.m_url.substring(this.m_schemeEnd + 3, this.m_serverNameEnd);
    }

    public final int getServerPort() {
        String port = this.m_url.substring(this.m_serverNameEnd, this.m_serverPortEnd);
        if (port.equals("")) {
            return 80;
        }
        return Integer.parseInt(port.substring(1));
    }

    public final String getServerURI() {
        return this.m_url.substring(0, this.m_serverPortEnd);
    }

    public final String getContextPath() {
        return this.m_url.substring(this.m_serverPortEnd, this.m_contextPathEnd);
    }

    public final String getDispatcherPrefix() {
        if (this.m_dispatcherPrefixEnd < this.m_servletPathEnd) {
            return "";
        }
        return this.m_url.substring(this.m_servletPathEnd, this.m_dispatcherPrefixEnd);
    }

    public final String getServletPath() {
        return this.m_url.substring(this.m_dispatcherPrefixEnd, this.m_servletPathEnd);
    }

    public final String getPathInfo() {
        String pathInfo = this.m_url.substring(this.m_servletPathEnd);
        if (pathInfo.equals("")) {
            return null;
        }
        return pathInfo;
    }

    public final String getRequestURI() {
        return this.m_url.substring(this.m_serverPortEnd);
    }

    public final String getQueryString() {
        if (this.m_params == null) {
            return null;
        }
        return this.m_params.getQueryString();
    }

    public final String getParameter(String name) {
        if (this.m_params == null) {
            return null;
        }
        return this.m_params.getParameter(name);
    }

    public final String[] getParameterValues(String name) {
        if (this.m_params == null) {
            return null;
        }
        return this.m_params.getParameterValues(name);
    }

    public final Map getParameterMap() {
        if (this.m_params == null) {
            return null;
        }
        return this.m_params.getParameterMap();
    }

    public static final URL root() {
        WebConfig config = Web.getConfig();
        URL url = new URL(config.getDefaultScheme(), config.getServer().getName(), config.getServer().getPort(), "", "/", null, null);
        return url;
    }

    public static final URL request(HttpServletRequest sreq, ParameterMap params) {
        URL url;
        if (params != null) {
            params.runListeners(sreq);
        }
        if ((url = Web.getContext().getRequestURL()) == null) {
            return new URL(sreq, params);
        }
        return new URL(url.getScheme(), url.getServerName(), url.getServerPort(), url.getContextPath(), url.getServletPath(), url.getPathInfo(), params);
    }

    public static final URL there(HttpServletRequest sreq, String path, ParameterMap params) {
        WebConfig config = Web.getConfig();
        Assert.assertNotNull(sreq, "HttpServletRequest sreq");
        Assert.assertNotNull(config, "WebConfig config");
        if (params != null) {
            params.runListeners(sreq);
        }
        HttpHost host = new HttpHost(sreq);
        return new URL(sreq.getScheme(), host.getName(), host.getPort(), config.getDispatcherContextPath(), config.getDispatcherServletPath(), path, params);
    }

    public static final URL there(HttpServletRequest sreq, String path) {
        WebConfig config = Web.getConfig();
        Assert.assertNotNull(sreq, "HttpServletRequest sreq");
        Assert.assertNotNull(config, "WebConfig config");
        HttpHost host = new HttpHost(sreq);
        return new URL(sreq.getScheme(), host.getName(), host.getPort(), config.getDispatcherContextPath(), config.getDispatcherServletPath(), path, (ParameterMap)s_empty.get());
    }

    public static final URL there(HttpServletRequest sreq, Application app, String pathInfo, ParameterMap params) {
        if (Assert.isAssertEnabled() && pathInfo != null) {
            Assert.assertTrue(pathInfo.startsWith("/"), "pathInfo, if not null, must start with a slash");
        }
        if (pathInfo == null) {
            return URL.there(sreq, app.getPath(), params);
        }
        return URL.there(sreq, app.getPath() + pathInfo, params);
    }

    public static final URL there(HttpServletRequest sreq, Application app, String pathInfo) {
        if (Assert.isAssertEnabled() && pathInfo != null) {
            Assert.assertTrue(pathInfo.startsWith("/"), "pathInfo, if not null, must start with a slash");
        }
        if (pathInfo == null) {
            return URL.there(sreq, app.getPath());
        }
        return URL.there(sreq, app.getPath() + pathInfo);
    }

    public static final URL there(String path, ParameterMap params) {
        WebConfig config = Web.getConfig();
        return new URL(config.getDefaultScheme(), config.getServer().getName(), config.getServer().getPort(), config.getDispatcherContextPath(), config.getDispatcherServletPath(), path, params);
    }

    public static final URL there(Application app, String pathInfo, ParameterMap params) {
        return URL.there(app.getPath() + pathInfo, params);
    }

    public static final URL here(HttpServletRequest sreq, String pathInfo, ParameterMap params) {
        Application app = Web.getContext().getApplication();
        Assert.assertNotNull(app, "Application app");
        return URL.there(sreq, app, pathInfo, params);
    }

    public static final URL here(HttpServletRequest sreq, String pathInfo) {
        Application app = Web.getContext().getApplication();
        Assert.assertNotNull(app, "Application app");
        return URL.there(sreq, app, pathInfo);
    }

    public static final URL excursion(HttpServletRequest sreq, String path, ParameterMap params) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Creating excursion URL to " + path));
        }
        URL url = URL.there(sreq, path, params);
        params.setParameter("return_url", Web.getContext().getRequestURL());
        return url;
    }

    public static final URL excursion(HttpServletRequest sreq, String path) {
        return URL.excursion(sreq, path, new ParameterMap());
    }

    static final URL login(HttpServletRequest sreq) {
        return URL.excursion(sreq, Util.getSecurityHelper().getLoginURL(sreq), (ParameterMap)s_empty.get());
    }

    final String getReturnURL() {
        return this.getParameter("return_url");
    }

    public final String toString() {
        if (this.m_params == null) {
            return this.m_url.substring(this.m_serverPortEnd);
        }
        return this.m_url.substring(this.m_serverPortEnd) + this.m_params;
    }

    public static final String getDispatcherPath() {
        WebConfig config = Web.getConfig();
        HttpServletRequest req = Web.getRequest();
        String context = config.getDispatcherContextPath();
        String servlet = config.getDispatcherServletPath();
        if (req == null) {
            return context + servlet;
        }
        String prefix = DispatcherHelper.getDispatcherPrefix(req);
        if (prefix == null) {
            return context + servlet;
        }
        return context + prefix + servlet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class EmptyParameterMap
    extends InternalRequestLocal {
        private EmptyParameterMap() {
        }

        protected final Object initialValue() {
            return new ParameterMap();
        }

        protected final void prepareValue(HttpServletRequest sreq) {
            ((ParameterMap)this.get()).runListeners(sreq);
        }

        protected final void clearValue() {
            ((ParameterMap)this.get()).clear();
        }
    }
}

