/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.URLFinderNotFoundException;
import com.arsdigita.kernel.URLService;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.OIDParameter;
import com.arsdigita.web.BaseServlet;
import com.arsdigita.web.RedirectSignal;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OIDRedirectServlet
extends BaseServlet {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$OIDRedirectServlet == null ? (class$com$arsdigita$web$OIDRedirectServlet = OIDRedirectServlet.class$("com.arsdigita.web.OIDRedirectServlet")) : class$com$arsdigita$web$OIDRedirectServlet));
    public static final String OID_PARAM = "oid";
    private static final OIDParameter param = new OIDParameter("oid");
    static /* synthetic */ Class class$com$arsdigita$web$OIDRedirectServlet;

    protected void doService(HttpServletRequest sreq, HttpServletResponse sresp) throws ServletException, IOException {
        OID oid = (OID)param.transformValue(sreq);
        if (oid == null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"No OID parameter supplied");
            }
            sresp.sendError(404);
            return;
        }
        try {
            String context = sreq.getParameter("context");
            String url = URLService.locate(oid, context);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Redirecting oid " + oid + " to " + url));
            }
            throw new RedirectSignal(url, false);
        }
        catch (URLFinderNotFoundException ex) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("No URL finder for oid " + oid));
            }
            sresp.sendError(404);
            return;
        }
        catch (NoValidURLException ex) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("No URL for oid " + oid));
            }
            sresp.sendError(404);
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

