/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.InitialRequestContext;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.KernelRequestContext;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.security.SessionContext;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.sitenode.SiteNodeRequestContext;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.BaseServlet;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class BaseApplicationServlet
extends BaseServlet {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/BaseApplicationServlet.java#34 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$BaseApplicationServlet == null ? (class$com$arsdigita$web$BaseApplicationServlet = BaseApplicationServlet.class$("com.arsdigita.web.BaseApplicationServlet")) : class$com$arsdigita$web$BaseApplicationServlet));
    public static final String APPLICATION_ID_ATTRIBUTE = (class$com$arsdigita$web$BaseApplicationServlet == null ? (class$com$arsdigita$web$BaseApplicationServlet = BaseApplicationServlet.class$("com.arsdigita.web.BaseApplicationServlet")) : class$com$arsdigita$web$BaseApplicationServlet).getName() + ".application_id";
    public static final String APPLICATION_ID_PARAMETER = "app-id";
    static /* synthetic */ Class class$com$arsdigita$web$BaseApplicationServlet;

    protected final void doService(final HttpServletRequest sreq, final HttpServletResponse sresp) throws ServletException, IOException {
        final Application app = this.getApplication(sreq);
        if (app == null) {
            sresp.sendError(404, "Application not found");
            throw new IllegalStateException("Application not found");
        }
        Web.getContext().setApplication(app);
        final RequestContext rc = this.makeLegacyContext(sreq, app, Web.getUserContext());
        DispatcherHelper.setRequestContext(sreq, rc);
        final ServletException[] servletException = new ServletException[]{null};
        final IOException[] ioException = new IOException[]{null};
        new KernelExcursion(){

            protected final void excurse() {
                this.setLocale(rc.getLocale());
                this.setResource(app);
                try {
                    BaseApplicationServlet.this.doService(sreq, sresp, app);
                }
                catch (ServletException se) {
                    servletException[0] = se;
                }
                catch (IOException ioe) {
                    ioException[0] = ioe;
                }
            }
        }.run();
        if (servletException[0] != null) {
            throw servletException[0];
        }
        if (ioException[0] != null) {
            throw ioException[0];
        }
    }

    protected abstract void doService(HttpServletRequest var1, HttpServletResponse var2, Application var3) throws ServletException, IOException;

    private Application getApplication(HttpServletRequest sreq) {
        s_log.debug((Object)"Resolving the application that will handle this request");
        BigDecimal id = (BigDecimal)sreq.getAttribute(APPLICATION_ID_ATTRIBUTE);
        if (id == null) {
            s_log.debug((Object)"I didn't receive an application ID with the servlet request; trying to get it from the query string");
            String value = sreq.getParameter(APPLICATION_ID_PARAMETER);
            if (value != null) {
                try {
                    id = new BigDecimal(value);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalStateException("Could not parse '" + value + "' into a BigDecimal");
                }
            }
        }
        Assert.assertNotNull(id, "BigDecimal id");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Retrieving application " + id + " from the " + "database"));
        }
        return Application.retrieveApplication(id);
    }

    private RequestContext makeLegacyContext(HttpServletRequest sreq, Application app, UserContext uc) {
        s_log.debug((Object)"Setting up a legacy context object");
        sreq = DispatcherHelper.restoreOriginalRequest(sreq);
        InitialRequestContext irc = new InitialRequestContext(sreq, this.getServletContext());
        SessionContext sc = uc.getSessionContext();
        KernelRequestContext krc = new KernelRequestContext(irc, sc, uc);
        SiteNode node = null;
        try {
            node = SiteNode.getSiteNode(app.getPrimaryURL(), true);
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("cannot find root sitenode");
        }
        if (node == null) {
            s_log.debug((Object)"There is no site node at this URL; storing a KernelRequestContext");
            return krc;
        }
        s_log.debug((Object)"Creating a SiteNodeRequestContext");
        SiteNodeRequestContext snrc = new SiteNodeRequestContext(sreq, krc, node, sreq.getServletPath() + "/");
        return snrc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

