/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.util.AssertionError;
import com.arsdigita.util.Graph;
import com.arsdigita.util.GraphEdge;
import com.arsdigita.util.GraphSet;
import com.arsdigita.versioning.EdgeLabel;
import com.arsdigita.versioning.GraphNode;
import com.arsdigita.versioning.NodeType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;

final class ObjectTypeMetadata {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$versioning$ObjectTypeMetadata == null ? (class$com$arsdigita$versioning$ObjectTypeMetadata = ObjectTypeMetadata.class$("com.arsdigita.versioning.ObjectTypeMetadata")) : class$com$arsdigita$versioning$ObjectTypeMetadata));
    private Graph m_dependenceGraph = new GraphSet();
    private Graph m_inheritanceForest;
    private Set m_unversionedProperties = new HashSet();
    private Set m_versionedProperties = new HashSet();
    private static final ObjectTypeMetadata s_singleton = new ObjectTypeMetadata();
    static /* synthetic */ Class class$com$arsdigita$versioning$ObjectTypeMetadata;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$persistence$metadata$Property;

    private ObjectTypeMetadata() {
    }

    public static ObjectTypeMetadata getInstance() {
        return s_singleton;
    }

    boolean isVersionedType(ObjectType objType) {
        return GraphNode.getInstance(objType).isVersionedType();
    }

    boolean isVersionedType(String objTypeFQN) {
        return this.isVersionedType(ObjectTypeMetadata.objType(objTypeFQN));
    }

    boolean isUnversionedProperty(Property prop) {
        return this.m_unversionedProperties.contains(prop);
    }

    boolean isUnversionedProperty(String containerName, String propertyName) {
        ObjectType objType = ObjectTypeMetadata.objType(containerName);
        return this.isUnversionedProperty(objType.getProperty(propertyName));
    }

    boolean isVersionedProperty(Property prop) {
        return this.m_versionedProperties.contains(prop);
    }

    boolean isVersionedProperty(String containerName, String propertyName) {
        ObjectType objType = ObjectTypeMetadata.objType(containerName);
        return this.isVersionedProperty(objType.getProperty(propertyName));
    }

    public boolean isUnreachable(ObjectType objType) {
        return GraphNode.getInstance(objType).isUnreachable();
    }

    public boolean isUnreachable(String objTypeFQN) {
        return this.isUnreachable(ObjectTypeMetadata.objType(objTypeFQN));
    }

    boolean isCoversionedType(ObjectType objType) {
        return GraphNode.getInstance(objType).isCoversionedType();
    }

    boolean isCoversionedType(String objTypeFQN) {
        return this.isCoversionedType(ObjectTypeMetadata.objType(objTypeFQN));
    }

    public boolean isRecoverable(ObjectType objType) {
        return GraphNode.getInstance(objType).isRecoverable();
    }

    public boolean isRecoverable(String objTypeFQN) {
        return this.isRecoverable(ObjectTypeMetadata.objType(objTypeFQN));
    }

    public boolean isFullyVersioned(ObjectType objType) {
        GraphNode node = GraphNode.getInstance(objType);
        return node.isVersionedType() || node.isCoversionedType();
    }

    public boolean isFullyVersioned(String objTypeFQN) {
        return this.isFullyVersioned(ObjectTypeMetadata.objType(objTypeFQN));
    }

    private static ObjectType objType(String fqn) {
        Assert.exists(fqn, class$java$lang$String == null ? (class$java$lang$String = ObjectTypeMetadata.class$("java.lang.String")) : class$java$lang$String);
        return MetadataRoot.getMetadataRoot().getObjectType(fqn);
    }

    private void resetObjectTypeInheritanceForest() {
        Iterator objTypes = MetadataRoot.getMetadataRoot().getObjectTypes().iterator();
        this.m_inheritanceForest = new GraphSet();
        while (objTypes.hasNext()) {
            ObjectType objType = (ObjectType)objTypes.next();
            this.m_inheritanceForest.addNode(objType);
            if (objType.getSupertype() == null) continue;
            this.m_inheritanceForest.addEdge(objType.getSupertype(), objType, null);
        }
    }

    synchronized void addGraphNode(GraphNode node, boolean isMarked) {
        this.m_dependenceGraph.addNode(node);
        if (isMarked) {
            node.setNodeType(NodeType.VERSIONED_TYPE);
        }
    }

    private Iterator nodes() {
        return this.m_dependenceGraph.getNodes().iterator();
    }

    private Graph.Edge getPropertyEdge(GraphNode tail, Property prop) {
        Iterator edges = this.m_dependenceGraph.getOutgoingEdges(tail).iterator();
        while (edges.hasNext()) {
            Graph.Edge edge = (Graph.Edge)edges.next();
            EdgeLabel label = (EdgeLabel)edge.getLabel();
            if (label == null || !prop.getName().equals(label.getProperty().getName())) continue;
            return edge;
        }
        return null;
    }

    synchronized void markEdgeUnversioned(Property prop) {
        Assert.exists(prop, class$com$arsdigita$persistence$metadata$Property == null ? (class$com$arsdigita$persistence$metadata$Property = ObjectTypeMetadata.class$("com.arsdigita.persistence.metadata.Property")) : class$com$arsdigita$persistence$metadata$Property);
        this.m_unversionedProperties.add(prop);
        if (prop.getType().isSimple()) {
            return;
        }
        GraphNode node = GraphNode.getInstance((ObjectType)prop.getContainer());
        Assert.truth(this.m_dependenceGraph.hasNode(node), "dependence graph has " + prop.getContainer());
        Graph.Edge edge = this.getPropertyEdge(node, prop);
        if (edge == null) {
            edge = ObjectTypeMetadata.propertyEdge(node, prop);
            this.m_dependenceGraph.addEdge(edge);
        }
        EdgeLabel edgeLabel = (EdgeLabel)edge.getLabel();
        edgeLabel.setUnversioned();
    }

    synchronized void addVersionedProperty(Property prop) {
        Assert.exists(prop, class$com$arsdigita$persistence$metadata$Property == null ? (class$com$arsdigita$persistence$metadata$Property = ObjectTypeMetadata.class$("com.arsdigita.persistence.metadata.Property")) : class$com$arsdigita$persistence$metadata$Property);
        this.m_versionedProperties.add(prop);
        Assert.falsity(prop.getType().isSimple(), "property is simple: " + prop);
        GraphNode tail = GraphNode.getInstance((ObjectType)prop.getContainer());
        Graph.Edge edge = null;
        if (this.m_dependenceGraph.hasNode(tail)) {
            edge = this.getPropertyEdge(tail, prop);
        } else {
            edge = ObjectTypeMetadata.propertyEdge(tail, prop);
            this.m_dependenceGraph.addEdge(edge);
        }
        if (edge == null) {
            edge = ObjectTypeMetadata.propertyEdge(tail, prop);
            this.m_dependenceGraph.addEdge(edge);
        }
        EdgeLabel label = (EdgeLabel)edge.getLabel();
        label.setVersioned();
        GraphNode head = (GraphNode)edge.getHead();
        if (head.getNodeType().lessThan(NodeType.COVERSIONED_TYPE)) {
            head.setNodeType(NodeType.COVERSIONED_TYPE);
        }
    }

    private void propagateFromMarked() {
        Iterator nodes = this.nodes();
        while (nodes.hasNext()) {
            GraphNode node = (GraphNode)nodes.next();
            if (!node.isVersionedType()) continue;
            this.propagateNodeType(node);
        }
    }

    private synchronized void propagateNodeType(GraphNode node) {
        this.promoteSubtypes(node);
        this.promotePropertyContainerTypes(node);
    }

    private void promoteSubtypes(GraphNode node) {
        Iterator childEdges = this.m_inheritanceForest.getOutgoingEdges(node.getObjectType()).iterator();
        while (childEdges.hasNext()) {
            Graph.Edge edge = (Graph.Edge)childEdges.next();
            GraphNode childNode = GraphNode.getInstance((ObjectType)edge.getHead());
            this.m_dependenceGraph.addEdge(ObjectTypeMetadata.subtypeEdge(node, childNode));
            if (!childNode.getNodeType().lessThan(node.getNodeType())) continue;
            childNode.setNodeType(node.getNodeType());
            this.propagateNodeType(childNode);
        }
    }

    private void promotePropertyContainerTypes(GraphNode node) {
        Iterator props = this.versionableCompoundProperties(node.getObjectType());
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            if (!(prop.getType() instanceof ObjectType)) continue;
            ObjectType propType = (ObjectType)prop.getType();
            Graph.Edge edge = ObjectTypeMetadata.propertyEdge(node, prop);
            this.m_dependenceGraph.addEdge(edge);
            GraphNode head = (GraphNode)edge.getHead();
            if (!head.getNodeType().lessThan(node.getNodeType())) continue;
            if (prop.isComponent()) {
                if (node.getNodeType() == NodeType.RECOVERABLE) {
                    head.setNodeType(NodeType.RECOVERABLE);
                } else {
                    head.setNodeType(NodeType.COVERSIONED_TYPE);
                }
            } else if (prop.isRequired() || this.isVersionedProperty(prop)) {
                head.setNodeType(NodeType.RECOVERABLE);
            } else {
                throw new AssertionError("can't possibly get here: " + prop);
            }
            this.propagateNodeType(head);
        }
    }

    void initialize() {
        this.resetObjectTypeInheritanceForest();
        this.propagateFromMarked();
    }

    private static Graph.Edge subtypeEdge(GraphNode tail, GraphNode head) {
        return new GraphEdge(tail, head, null);
    }

    private static Graph.Edge propertyEdge(GraphNode tail, Property prop) {
        return new GraphEdge(tail, GraphNode.getInstance((ObjectType)prop.getType()), new EdgeLabel(prop));
    }

    private static GraphNode node(ObjectType objType) {
        return GraphNode.getInstance(objType);
    }

    private Iterator versionableCompoundProperties(ObjectType objType) {
        LinkedList<Property> props = new LinkedList<Property>();
        Iterator ii = objType.getProperties();
        while (ii.hasNext()) {
            Property prop = (Property)ii.next();
            if (this.isUnversionedProperty(prop) || !prop.getType().isCompound() || !prop.isRequired() && !prop.isComponent() && !this.isVersionedProperty(prop)) continue;
            props.add(prop);
        }
        return props.iterator();
    }

    Graph getDependenceGraph() {
        return this.m_dependenceGraph.copy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

