/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.DataType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.persistence.metadata.SimpleType;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.Converter;
import com.arsdigita.versioning.SimpleConverter;
import com.arsdigita.versioning.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

final class Adapter {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$versioning$Adapter == null ? (class$com$arsdigita$versioning$Adapter = Adapter.class$("com.arsdigita.versioning.Adapter")) : class$com$arsdigita$versioning$Adapter));
    private static final String s_dateDelim = ":";
    private static final String s_oidDelim = ";";
    private static final String s_tstampDelim = ".";
    private static final Map s_converters = new HashMap();
    static /* synthetic */ Class class$com$arsdigita$versioning$Adapter;
    static /* synthetic */ Class class$com$arsdigita$versioning$Types;
    static /* synthetic */ Class class$com$arsdigita$persistence$metadata$Property;
    static /* synthetic */ Class class$java$lang$Object;

    private Adapter() {
    }

    public static String serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        return Adapter.getConverter(Types.getObjectType(obj)).serialize(obj);
    }

    public static Object deserialize(String value, Types type) {
        if (value == null) {
            return null;
        }
        return Adapter.getConverter(type).deserialize(value);
    }

    private static Converter getConverter(Types type) {
        Assert.exists(type, class$com$arsdigita$versioning$Types == null ? (class$com$arsdigita$versioning$Types = Adapter.class$("com.arsdigita.versioning.Types")) : class$com$arsdigita$versioning$Types);
        return (Converter)s_converters.get(type);
    }

    private static void initializeAdapters() {
        s_converters.put(Types.BIG_DECIMAL, new SimpleConverter(){

            public Object deserialize(String str) {
                return new BigDecimal(str);
            }
        });
        s_converters.put(Types.BIG_INTEGER, new SimpleConverter(){

            public Object deserialize(String str) {
                return new BigInteger(str);
            }
        });
        s_converters.put(Types.BOOLEAN, new SimpleConverter(){

            public Object deserialize(String str) {
                return Boolean.valueOf(str);
            }
        });
        s_converters.put(Types.BYTE, new SimpleConverter(){

            public Object deserialize(String str) {
                return Byte.valueOf(str);
            }
        });
        s_converters.put(Types.CHARACTER, new SimpleConverter(){

            public Object deserialize(String str) {
                Assert.truth(str.length() == 1, "str.length() == 1");
                return new Character(str.charAt(0));
            }
        });
        s_converters.put(Types.DATE, new Converter(){

            public String serialize(Object obj) {
                Date date = (Date)obj;
                StringBuffer result = new StringBuffer(100);
                result.append(date.getTime());
                result.append(Adapter.s_dateDelim);
                result.append(date.toString());
                return result.toString();
            }

            public Object deserialize(String str) {
                int idx = str.indexOf(Adapter.s_dateDelim);
                Assert.truth(idx >= 0, "idx>0");
                return new Date(Long.parseLong(str.substring(0, idx)));
            }
        });
        s_converters.put(Types.DOUBLE, new SimpleConverter(){

            public Object deserialize(String str) {
                return new Double(str);
            }
        });
        s_converters.put(Types.FLOAT, new SimpleConverter(){

            public Object deserialize(String str) {
                return new Float(str);
            }
        });
        s_converters.put(Types.INTEGER, new SimpleConverter(){

            public Object deserialize(String str) {
                return new Integer(str);
            }
        });
        s_converters.put(Types.LONG, new SimpleConverter(){

            public Object deserialize(String str) {
                return new Long(str);
            }
        });
        s_converters.put(Types.OID, new Converter(){

            public String serialize(Object obj) {
                return Adapter.serializeOID((OID)obj);
            }

            public Object deserialize(String str) {
                return Adapter.deserializeOID(str);
            }
        });
        s_converters.put(Types.SHORT, new SimpleConverter(){

            public Object deserialize(String str) {
                return new Short(str);
            }
        });
        s_converters.put(Types.STRING, new SimpleConverter(){

            public Object deserialize(String str) {
                return str;
            }
        });
        s_converters.put(Types.TIMESTAMP, new Converter(){

            public String serialize(Object obj) {
                Timestamp tstamp = (Timestamp)obj;
                StringBuffer result = new StringBuffer(100);
                result.append(tstamp.getTime());
                result.append(Adapter.s_tstampDelim);
                result.append(tstamp.getNanos());
                result.append(Adapter.s_dateDelim);
                result.append(tstamp.toString());
                return result.toString();
            }

            public Object deserialize(String str) {
                int mIdx = str.indexOf(Adapter.s_tstampDelim);
                Assert.truth(mIdx >= 0, "mIdx>0");
                long millis = Long.parseLong(str.substring(0, mIdx));
                int nIdx = str.indexOf(Adapter.s_dateDelim, mIdx);
                Assert.truth(nIdx >= 0, "nIdx>0");
                int nanos = Integer.parseInt(str.substring(mIdx + 1, nIdx));
                Timestamp result = new Timestamp(millis);
                result.setNanos(nanos);
                return result;
            }
        });
    }

    private static Types getType(Property prop) {
        Assert.exists(prop, class$com$arsdigita$persistence$metadata$Property == null ? (class$com$arsdigita$persistence$metadata$Property = Adapter.class$("com.arsdigita.persistence.metadata.Property")) : class$com$arsdigita$persistence$metadata$Property);
        DataType dataType = prop.getType();
        if (dataType.isSimple()) {
            return Types.getType((SimpleType)dataType);
        }
        throw new Error("not implemented for compound types yet");
    }

    private static String serializeOID(OID oid) {
        ArrayList<String> keyValuePairs = new ArrayList<String>();
        Iterator props = oid.getObjectType().getKeyProperties();
        while (props.hasNext()) {
            Property prop = (Property)props.next();
            String pName = prop.getName();
            Object pValue = oid.get(pName);
            Assert.exists(pValue, class$java$lang$Object == null ? Adapter.class$("java.lang.Object") : class$java$lang$Object);
            Types type = Adapter.getType(prop);
            int sep = 58;
            StringBuffer packed = new StringBuffer();
            packed.append(pName).append(':').append(type.getID()).append(':');
            packed.append(Adapter.serialize(pValue));
            keyValuePairs.add(packed.toString());
        }
        Assert.truth(keyValuePairs.size() > 0, "oid has at least one property");
        if (keyValuePairs.size() > 1) {
            Collections.sort(keyValuePairs);
        }
        StringBuffer result = new StringBuffer(64);
        result.append(oid.getObjectType().getQualifiedName());
        Iterator ii = keyValuePairs.iterator();
        while (ii.hasNext()) {
            String value = (String)ii.next();
            result.append(s_oidDelim).append(value);
        }
        return result.toString();
    }

    private static OID deserializeOID(String str) {
        StringTokenizer st = new StringTokenizer(str, s_oidDelim);
        Assert.truth(st.hasMoreTokens(), str);
        OID oid = new OID(st.nextToken());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            StringTokenizer tuple = new StringTokenizer(token, s_dateDelim);
            Assert.truth(tuple.hasMoreTokens(), token);
            String pName = tuple.nextToken();
            Assert.truth(tuple.hasMoreTokens(), token);
            String pType = tuple.nextToken();
            Assert.truth(tuple.hasMoreTokens(), token);
            String pValue = token.substring(pName.length() + pType.length() + 2);
            oid.set(pName, Adapter.deserialize(pValue, Types.getType(new BigInteger(pType))));
        }
        return oid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Adapter.initializeAdapters();
    }
}

