/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Tree {
    private Tree m_parent;
    private final Object m_root;
    private final List m_children;
    private String m_label;

    public Tree(Object root) {
        this(null, root);
    }

    private Tree(Tree parent, Object root) {
        this.m_parent = parent;
        this.m_root = root;
        this.m_children = new ArrayList();
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public String getLabel() {
        return this.m_label;
    }

    public Object getRoot() {
        return this.m_root;
    }

    public Tree addChild(Object child, Object edge) {
        Tree tree = new Tree(this, child);
        this.m_children.add(new EdgeTreePair(edge, tree));
        return tree;
    }

    public Tree addChild(Object child) {
        return this.addChild(child, null);
    }

    public void addSubtree(Tree subtree, Object edge) {
        Assert.assertNotNull(subtree, "subtree");
        Assert.assertTrue(subtree.getParent() == null, "parent must be null");
        subtree.m_parent = this;
        this.m_children.add(new EdgeTreePair(edge, subtree));
    }

    public void addSubtree(Tree subtree) {
        this.addSubtree(subtree, null);
    }

    public Tree getParent() {
        return this.m_parent;
    }

    public List getSubtrees() {
        return new ArrayList(this.m_children);
    }

    public Tree copy() {
        Tree result = new Tree(this.getRoot());
        Tree.copyRecurse(this, result);
        return result;
    }

    private static void copyRecurse(Tree from, Tree to) {
        Iterator children = from.getSubtrees().iterator();
        while (children.hasNext()) {
            EdgeTreePair pair = (EdgeTreePair)children.next();
            Tree result = to.addChild(pair.getTree().getRoot(), pair.getEdge());
            Tree.copyRecurse(pair.getTree(), result);
        }
    }

    public int nodeCount() {
        return Tree.nodeCountRecurse(this);
    }

    private static int nodeCountRecurse(Tree tree) {
        int result = 1;
        Iterator ii = tree.getSubtrees().iterator();
        while (ii.hasNext()) {
            EdgeTreePair pair = (EdgeTreePair)ii.next();
            result += Tree.nodeCountRecurse(pair.getTree());
        }
        return result;
    }

    public int depth() {
        return Tree.depthRecurse(this);
    }

    private static int depthRecurse(Tree tree) {
        if (tree.getSubtrees().size() == 0) {
            return 1;
        }
        int maxDepth = 0;
        Iterator ii = tree.getSubtrees().iterator();
        while (ii.hasNext()) {
            EdgeTreePair pair = (EdgeTreePair)ii.next();
            int depth = Tree.depthRecurse(pair.getTree());
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth + 1;
    }

    public List getAncestors() {
        ArrayList result = new ArrayList();
        if (this.getParent() == null) {
            return result;
        }
        Tree.ancestorsRecurse(this.getParent(), result);
        return result;
    }

    private static void ancestorsRecurse(Tree node, List accumulator) {
        accumulator.add(node);
        if (node.getParent() != null) {
            Tree.ancestorsRecurse(node.getParent(), accumulator);
        }
    }

    public static List treesToNodes(List trees) {
        Assert.assertNotNull(trees, "trees");
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator ii = trees.iterator();
        while (ii.hasNext()) {
            result.add(((Tree)ii.next()).getRoot());
        }
        return result;
    }

    public static class EdgeTreePair {
        private Object m_edge;
        private Tree m_tree;

        private EdgeTreePair(Object edge, Tree tree) {
            this.m_edge = edge;
            this.m_tree = tree;
        }

        public Object getEdge() {
            return this.m_edge;
        }

        public Tree getTree() {
            return this.m_tree;
        }
    }
}

