/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class ResourceManager {
    private static final String CONFIGURE_MESSAGE = "Must configure ResourceManager by calling setWebappRoot or setServletContext before use.";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$ResourceManager == null ? (class$com$arsdigita$util$ResourceManager = ResourceManager.class$("com.arsdigita.util.ResourceManager")) : class$com$arsdigita$util$ResourceManager));
    private static ResourceManager s_instance = new ResourceManager();
    private File m_webappRoot;
    private ServletContext m_servletContext;
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/ResourceManager.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    static /* synthetic */ Class class$com$arsdigita$util$ResourceManager;

    private ResourceManager() {
    }

    public static ResourceManager getInstance() {
        return s_instance;
    }

    public InputStream getResourceAsStream(String url) {
        if (this.m_webappRoot == null && this.m_servletContext == null) {
            throw new IllegalStateException(CONFIGURE_MESSAGE);
        }
        if (StringUtils.emptyString(url)) {
            throw new IllegalArgumentException("URL is empty: " + url);
        }
        if (this.m_servletContext != null) {
            InputStream is = this.m_servletContext.getResourceAsStream(url);
            if (is == null) {
                String errorMessage = "Failed to retrieve resource: " + url + "\nReal Path: " + this.m_servletContext.getRealPath(url);
                if (s_log.getAllAppenders().hasMoreElements()) {
                    s_log.error((Object)errorMessage);
                } else {
                    System.err.println(errorMessage);
                }
            }
            return is;
        }
        try {
            return new FileInputStream(new File(this.m_webappRoot, url));
        }
        catch (FileNotFoundException fnfe) {
            String errorMessage = "Failed to retrieve resource: " + url + "\nWebapp Root: " + this.m_webappRoot;
            if (s_log.getAllAppenders().hasMoreElements()) {
                s_log.error((Object)errorMessage);
            } else {
                System.err.println(errorMessage);
            }
            return null;
        }
    }

    public String getResourcePath(String url) {
        if (this.m_webappRoot == null && this.m_servletContext == null) {
            throw new IllegalStateException(CONFIGURE_MESSAGE);
        }
        if (StringUtils.emptyString(url)) {
            throw new IllegalArgumentException("URL is empty: " + url);
        }
        if (this.m_servletContext != null) {
            return this.m_servletContext.getRealPath(url);
        }
        File f = new File(this.m_webappRoot, url);
        return f.getAbsolutePath();
    }

    public File getResourceAsFile(String url) {
        if (this.m_servletContext == null) {
            throw new IllegalStateException(CONFIGURE_MESSAGE);
        }
        return new File(this.m_servletContext.getRealPath(url));
    }

    public void setWebappRoot(File f) {
        this.m_webappRoot = f;
    }

    public void setServletContext(ServletContext sctx) {
        this.m_servletContext = sctx;
        this.m_webappRoot = new File(sctx.getRealPath("/"));
    }

    public ServletContext getServletContext() {
        return this.m_servletContext;
    }

    public File getWebappRoot() {
        return this.m_webappRoot;
    }

    public long getLastModified(String path) {
        if (this.m_webappRoot == null) {
            throw new IllegalStateException(CONFIGURE_MESSAGE);
        }
        return new File(this.m_webappRoot, path).lastModified();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_instance = new ResourceManager();
    }
}

