/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import java.util.Comparator;
import java.util.TreeSet;

public class PriorityQueue {
    private TreeSet m_model = new TreeSet(new PQComparator());
    private boolean m_ascending;

    public PriorityQueue() {
        this(true);
    }

    public PriorityQueue(boolean ascending) {
        this.m_ascending = ascending;
    }

    public Object dequeue() {
        PQEntry pq = this.m_ascending ? (PQEntry)this.m_model.first() : (PQEntry)this.m_model.last();
        this.m_model.remove(pq);
        return pq.m_object;
    }

    public Object peek() {
        PQEntry pq = this.m_ascending ? (PQEntry)this.m_model.first() : (PQEntry)this.m_model.last();
        return pq.m_object;
    }

    public void enqueue(Object object, int priority) {
        this.m_model.add(new PQEntry(object, priority));
    }

    public boolean isEmpty() {
        return this.m_model.isEmpty();
    }

    public void setAscending(boolean ascending) {
        this.m_ascending = ascending;
    }

    public int size() {
        return this.m_model.size();
    }

    private class PQEntry {
        public int m_priority;
        public Object m_object;

        public PQEntry(Object object, int priority) {
            this.m_priority = priority;
            this.m_object = object;
        }
    }

    private class PQComparator
    implements Comparator {
        private PQComparator() {
        }

        public int compare(Object o1, Object o2) {
            PQEntry pq1 = (PQEntry)o1;
            PQEntry pq2 = (PQEntry)o2;
            if (pq1.m_priority < pq2.m_priority) {
                return -1;
            }
            if (pq1.m_priority > pq2.m_priority) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o1, Object o2) {
            return this.compare(o1, o2) == 0;
        }
    }
}

