/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Cache {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/Cache.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Cache s_instance = new Cache(32000L);
    private HashMap m_map = new HashMap();
    private long m_maxSize;
    private long m_curSize;
    private long m_maxAge;

    public Cache(long size) {
        this(size, 0L);
    }

    public Cache(long size, long maxAge) {
        this.m_maxSize = size;
        this.m_curSize = 0L;
        this.m_maxAge = maxAge;
    }

    public void put(Object key, Object value) {
        this.put(key, value, this.m_maxAge);
    }

    public void put(Object key, Object value, long maxAge) {
        Entry e = new Entry(value, System.currentTimeMillis(), maxAge);
        if (this.m_curSize >= this.m_maxSize) {
            Iterator iter = this.m_map.entrySet().iterator();
            long min = Long.MAX_VALUE;
            Object minKey = null;
            while (iter.hasNext()) {
                Map.Entry ent = iter.next();
                Entry e2 = (Entry)this.m_map.get(ent.getKey());
                long now = System.currentTimeMillis();
                if (e2.m_lastUse >= min && (e2.m_maxAge <= 0L || e2.m_creationTime >= now - e2.m_maxAge)) continue;
                min = e2.m_lastUse;
                minKey = ent.getKey();
            }
            this.m_map.remove(minKey);
            --this.m_curSize;
        }
        ++this.m_curSize;
        this.m_map.put(key, e);
    }

    public Object get(Object key) {
        long now;
        Entry e = (Entry)this.m_map.get(key);
        if (e == null) {
            return null;
        }
        if (this.m_maxAge > 0L && e.m_creationTime < (now = System.currentTimeMillis()) - this.m_maxAge) {
            this.m_map.remove(key);
            return null;
        }
        e.m_lastUse = System.currentTimeMillis();
        return e.m_o;
    }

    public void remove(Object key) {
        this.m_map.remove(key);
    }

    public void clear() {
        this.m_map.clear();
    }

    public static synchronized void putGlobal(Object key, Object value) {
        s_instance.put(key, value, Cache.s_instance.m_maxAge);
    }

    public static synchronized void putGlobal(Object key, Object value, long maxAge) {
        s_instance.put(key, value, maxAge);
    }

    public static synchronized void removeGlobal(Object key) {
        s_instance.remove(key);
    }

    public static synchronized Object getGlobal(Object key) {
        return s_instance.get(key);
    }

    private static class Entry {
        Object m_o;
        long m_lastUse;
        long m_creationTime;
        long m_maxAge;

        Entry(Object o, long lastUse, long maxAge) {
            this.m_o = o;
            this.m_lastUse = lastUse;
            this.m_creationTime = System.currentTimeMillis();
            this.m_maxAge = maxAge;
        }
    }
}

