/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.BebopMapDispatcher;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.ui.login.UserAuthenticationListener;
import com.arsdigita.ui.permissions.IndexPanel;
import com.arsdigita.ui.permissions.PermissionsConstants;
import com.arsdigita.ui.permissions.PermissionsPane;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PermissionsDispatcher
extends BebopMapDispatcher
implements PermissionsConstants {
    public static final String APPLICATION_NAME = "permissions";

    public PermissionsDispatcher() {
        Page index = this.buildIndexPage();
        Page single = this.buildItemPage();
        this.addPage("", index);
        this.addPage("index", index);
        this.addPage("one", single);
        this.addPage("grant", single);
        this.addPage("denied", this.buildDeniedPage());
    }

    protected void preprocessRequest(HttpServletRequest req, HttpServletResponse resp, RequestContext ctx, String url) {
        DispatcherHelper.cacheDisable(resp);
    }

    private Page buildIndexPage() {
        Label title = new Label(PermissionsConstants.PERMISSIONS_INDEX);
        title.setClassAttr("heading");
        Page p = PageFactory.buildPage(APPLICATION_NAME, title);
        p.addRequestListener(new UserAuthenticationListener());
        p.add(new IndexPanel());
        p.lock();
        return p;
    }

    private Page buildDeniedPage() {
        Page p = PageFactory.buildPage(APPLICATION_NAME, new Label(PermissionsConstants.PAGE_DENIED_TITLE));
        Label label = new Label();
        label.setClassAttr("AccessDenied");
        p.add(label);
        p.lock();
        return p;
    }

    private Page buildItemPage() {
        PermissionsPane pane = new PermissionsPane();
        Page p = PageFactory.buildPage(APPLICATION_NAME, pane.getTitle());
        p.addRequestListener(new UserAuthenticationListener());
        p.add(pane);
        p.lock();
        return p;
    }
}

