/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.ui.admin.AdminConstants;
import com.arsdigita.ui.admin.AdminSplitPanel;
import com.arsdigita.ui.admin.SearchAndList;
import com.arsdigita.ui.admin.UserBrowsePane;
import com.arsdigita.ui.admin.UserSearchAndListModel;
import java.math.BigDecimal;

class UserSearchPane
extends SegmentedPanel
implements AdminConstants,
Resettable,
ChangeListener {
    private SearchAndList m_searchAndList;
    private AdminSplitPanel m_splitPanel;
    private UserBrowsePane m_userBrowsePane;

    public UserSearchPane(AdminSplitPanel panel, UserBrowsePane userBrowsePane) {
        this.m_splitPanel = panel;
        this.m_userBrowsePane = userBrowsePane;
        this.m_searchAndList = this.makeUserSearch();
        SimpleContainer body = new SimpleContainer();
        body.add(this.m_searchAndList);
        this.addSegment(AdminConstants.SEARCH_PANEL_HEADER, (Component)body);
    }

    public void reset(PageState ps) {
        this.m_searchAndList.reset(ps);
    }

    private SearchAndList makeUserSearch() {
        SearchAndList s = new SearchAndList("user_search");
        s.addChangeListener(this);
        s.setListModel(new UserSearchAndListModel());
        s.setResultCellRenderer(new ListCellRenderer(){

            public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
                return new ControlLink(value.toString());
            }
        });
        return s;
    }

    public void stateChanged(ChangeEvent e) {
        PageState ps = e.getPageState();
        this.m_splitPanel.setTab(1, e.getPageState());
        String id = (String)this.m_searchAndList.getSelectedKey(ps);
        if (id != null) {
            ps.setValue(AdminConstants.USER_ID_PARAM, new BigDecimal(id));
            this.m_userBrowsePane.displayUserInfoPanel(ps);
        } else {
            this.reset(ps);
        }
    }
}

