/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.sitenode;

import com.arsdigita.bebop.page.PageTransformer;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.Stylesheet;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.sitenode.SiteNodeRequestContext;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Debugger;
import com.arsdigita.web.TransformationDebugger;
import com.arsdigita.xml.Document;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;

public class BasePresentationManager
implements PresentationManager {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/sitenode/BasePresentationManager.java#36 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$sitenode$BasePresentationManager == null ? (class$com$arsdigita$sitenode$BasePresentationManager = BasePresentationManager.class$("com.arsdigita.sitenode.BasePresentationManager")) : class$com$arsdigita$sitenode$BasePresentationManager));
    private Map m_stylesheetMap = new HashMap();
    private static BasePresentationManager s_instance = new BasePresentationManager();
    public static final String CACHE_NONE = "none";
    public static final String CACHE_DISABLE = "disable";
    public static final String CACHE_USER = "user";
    public static final String CACHE_WORLD = "world";
    private static String m_defaultCachePolicy = "disable";
    static /* synthetic */ Class class$com$arsdigita$sitenode$BasePresentationManager;

    public static void setDefaultCachePolicy(String policy) {
        m_defaultCachePolicy = policy;
    }

    protected static PrintWriter getPrintWriter(HttpServletResponse resp, String charset) throws IOException {
        try {
            return resp.getWriter();
        }
        catch (IllegalStateException e) {
            s_log.debug((Object)"Using getOutputStream instead of getWriter");
            if (charset == null) {
                return new PrintWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream()));
            }
            try {
                return new PrintWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream(), charset));
            }
            catch (UnsupportedEncodingException ex) {
                throw new UncheckedWrapperException(charset + " is not a supported charset", ex);
            }
        }
    }

    public static PresentationManager getInstance() {
        return s_instance;
    }

    protected Stylesheet findStylesheet(SiteNodeRequestContext rctx) {
        return this.findStylesheet(rctx.getSiteNode(), rctx.getLocale(), rctx.getOutputType());
    }

    protected synchronized Stylesheet findStylesheet(SiteNode sn, Locale l, String outputType) {
        String mapKey = sn.getNodeId() + "|" + l.toString() + "|" + outputType;
        Stylesheet stylesheet = (Stylesheet)this.m_stylesheetMap.get(mapKey);
        if (stylesheet != null && stylesheet.isValid()) {
            return stylesheet;
        }
        stylesheet = this.findStylesheetHelper(sn, l, outputType);
        stylesheet.disconnect();
        this.m_stylesheetMap.put(mapKey, stylesheet);
        return stylesheet;
    }

    private Stylesheet findStylesheetHelper(SiteNode sn, Locale l, String outputType) {
        SiteNode thisNode;
        TransactionContext tctx = SessionManager.getSession().getTransactionContext();
        boolean callerStartedTransaction = tctx.inTxn();
        if (!callerStartedTransaction) {
            tctx.beginTxn();
        }
        Stylesheet thisStyle = null;
        for (thisNode = sn; thisNode != null && thisStyle == null; thisNode = thisNode.getParent()) {
            thisStyle = thisNode.getStylesheet(l, outputType);
        }
        for (thisNode = sn; thisNode != null && thisStyle == null; thisNode = thisNode.getParent()) {
            PackageInstance pi = thisNode.getPackageInstance();
            if (pi == null) continue;
            thisStyle = pi.getType().getStylesheet(l, outputType);
        }
        if (!callerStartedTransaction) {
            tctx.commitTxn();
        }
        return thisStyle;
    }

    public void servePage(Document doc, HttpServletRequest req, HttpServletResponse resp) {
        this.servePage(doc, req, resp, null);
    }

    public void servePage(Document doc, HttpServletRequest req, HttpServletResponse resp, Map params) {
        RequestContext ctx = DispatcherHelper.getRequestContext(req);
        try {
            String output;
            DeveloperSupport.startStage("PresMgr get stylesheet");
            String defaultCharset = Globalization.getDefaultCharset(ctx.getLocale());
            Stylesheet ss = this.findStylesheet((SiteNodeRequestContext)ctx);
            if (CACHE_WORLD.equals(m_defaultCachePolicy)) {
                DispatcherHelper.maybeCacheForWorld(resp);
            } else if (CACHE_USER.equals(m_defaultCachePolicy)) {
                DispatcherHelper.maybeCacheForUser(resp);
            } else if (CACHE_DISABLE.equals(m_defaultCachePolicy)) {
                DispatcherHelper.maybeCacheDisable(resp);
            }
            String string = output = req.getParameter("output") == null ? "html" : req.getParameter("output");
            if (ctx.getDebuggingXML() || output.equals("xml")) {
                resp.setContentType("text/xml; charset=" + defaultCharset);
                PrintWriter writer = BasePresentationManager.getPrintWriter(resp, defaultCharset);
                writer.print(doc.toString(true));
            } else if (ctx.getDebuggingXSL() || output.equals("xsl")) {
                resp.reset();
                resp.setContentType("application/zip");
                resp.setHeader("Content-Disposition", "attachment; filename=\"styles.jar\"");
                ServletOutputStream os = resp.getOutputStream();
                byte[] jarFile = ss.getAllStylesheetContents(ctx.getServletContext());
                os.write(jarFile, 0, jarFile.length);
                resp.flushBuffer();
            } else {
                Transformer xf = null;
                if (ss != null) {
                    xf = ss.newTransformer();
                }
                if (ss == null || xf == null) {
                    throw new ServletException("No stylesheet available for request!");
                }
                DeveloperSupport.endStage("PresMgr get stylesheet");
                this.completeTransaction(req);
                DeveloperSupport.startStage("PresMgr transform");
                resp.setContentType(ctx.getOutputType() + "; " + "charset=" + defaultCharset);
                PrintWriter writer = BasePresentationManager.getPrintWriter(resp, defaultCharset);
                xf.clearParameters();
                if (params != null) {
                    Iterator entries = params.entrySet().iterator();
                    while (entries.hasNext()) {
                        Map.Entry ent = entries.next();
                        xf.setParameter((String)ent.getKey(), ent.getValue());
                    }
                }
                PageTransformer.addXSLParameters(xf, req);
                xf.setOutputProperty("encoding", defaultCharset);
                xf.transform(new DOMSource(doc.getInternalDocument()), new StreamResult(writer));
                DeveloperSupport.endStage("PresMgr transform");
                if (Kernel.getConfig().isDebugEnabled()) {
                    Document origDoc = (Document)req.getAttribute("com.arsdigita.xml.Document");
                    ServletContext sctx = ctx.getServletContext();
                    String path = ss.getPath();
                    URL sheet = new File(sctx.getRealPath(path)).toURL();
                    Debugger.addDebugger(new TransformationDebugger(origDoc, doc, sheet, ss.getStylesheetList(sctx)));
                    writer.print(Debugger.getDebugging(req));
                }
            }
        }
        catch (TransformerConfigurationException tce) {
            throw new UncheckedWrapperException(tce);
        }
        catch (TransformerException te) {
            throw new UncheckedWrapperException(te);
        }
        catch (ClassCastException cce) {
            throw new UncheckedWrapperException(cce);
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException(ex);
        }
        catch (ServletException ex) {
            throw new UncheckedWrapperException(ex);
        }
    }

    private void completeTransaction(HttpServletRequest req) {
        String JSP_EXCEPTION_ATTRIBUTE = "javax.servlet.jsp.jspException";
        Session sess = SessionManager.getSession();
        TransactionContext txc = sess.getTransactionContext();
        if (req.getAttribute("javax.servlet.jsp.jspException") == null) {
            s_log.debug((Object)"trying to commit");
            Kernel.getContext().getTransaction().end();
            s_log.debug((Object)"request over, committing transaction");
        } else {
            s_log.debug((Object)"trying to abort");
            txc.abortTxn();
            s_log.debug((Object)"request over, aborting transaction");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

