/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.lucene;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.IndexerType;
import com.arsdigita.search.QueryEngine;
import com.arsdigita.search.QueryEngineRegistry;
import com.arsdigita.search.Search;
import com.arsdigita.search.filters.ObjectTypeFilterType;
import com.arsdigita.search.lucene.BaseQueryEngine;
import com.arsdigita.search.lucene.Index;
import com.arsdigita.search.lucene.IndexId;
import com.arsdigita.search.lucene.Indexer;
import com.arsdigita.search.lucene.LuceneConfig;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.TimerTask;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;

public class Initializer
implements com.arsdigita.initializer.Initializer {
    private static final Logger LOG = Logger.getLogger((Class)(class$com$arsdigita$search$lucene$Initializer == null ? (class$com$arsdigita$search$lucene$Initializer = Initializer.class$("com.arsdigita.search.lucene.Initializer")) : class$com$arsdigita$search$lucene$Initializer));
    public static final Loader LOADER = new IndexId.LoaderImpl();
    private Configuration m_conf = new Configuration();
    static /* synthetic */ Class class$com$arsdigita$search$lucene$Initializer;

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    public void startup() {
        if (Search.getConfig().isLuceneEnabled()) {
            LuceneConfig conf = LuceneConfig.getConfig();
            String location = conf.getIndexLocation();
            int interval = conf.getIndexerInterval();
            LOG.info((Object)("Lucene index location: " + location));
            try {
                if (!IndexReader.indexExists((String)location)) {
                    File f = new File(location);
                    f.mkdirs();
                    IndexWriter iw = new IndexWriter(location, (Analyzer)new StandardAnalyzer(), true);
                    iw.close();
                    LOG.info((Object)"Lucene created index directory");
                }
            }
            catch (IOException ex) {
                throw new InitializationException("lucene index id has not been initialized", ex);
            }
            Index.setLocation(location);
            Date delayedStart = new Date(System.currentTimeMillis() + 5000L);
            Index.getTimer().schedule((TimerTask)new Indexer(Index.getLocation()), delayedStart, (long)interval * 1000L);
            QueryEngineRegistry.registerEngine(IndexerType.LUCENE, new FilterType[0], (QueryEngine)new BaseQueryEngine());
            QueryEngineRegistry.registerEngine(IndexerType.LUCENE, new FilterType[]{new ObjectTypeFilterType()}, (QueryEngine)new BaseQueryEngine());
        }
    }

    public void shutdown() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Loader {
        public void load();
    }
}

