/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.search.lucene;

import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.search.FilterSpecification;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.QueryEngine;
import com.arsdigita.search.QuerySpecification;
import com.arsdigita.search.ResultSet;
import com.arsdigita.search.Search;
import com.arsdigita.search.filters.ObjectTypeFilterSpecification;
import com.arsdigita.search.lucene.IntersectionFilter;
import com.arsdigita.search.lucene.LuceneResultSet;
import com.arsdigita.search.lucene.LuceneSearch;
import com.arsdigita.search.lucene.NegationFilter;
import com.arsdigita.search.lucene.ObjectTypeFilter;
import com.arsdigita.search.lucene.UnionFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Filter;

public class BaseQueryEngine
implements QueryEngine {
    public ResultSet process(QuerySpecification spec) {
        String terms = spec.getTerms();
        if (terms == null || "".equals(terms)) {
            return Search.EMPTY_RESULT_SET;
        }
        ArrayList filters = new ArrayList();
        this.addFilters(filters, spec.getFilters());
        LuceneSearch search = null;
        search = filters.size() == 0 ? new LuceneSearch(terms) : new LuceneSearch(terms, new IntersectionFilter(filters.toArray(new Filter[filters.size()])));
        return new LuceneResultSet(search);
    }

    protected void addFilters(List list, FilterSpecification[] filters) {
        for (int i = 0; i < filters.length; ++i) {
            this.addFilter(list, filters[i]);
        }
    }

    protected void addFilter(List list, FilterSpecification filter) {
        FilterType type = filter.getType();
        if ("objectType".equals(type.getKey())) {
            this.addObjectTypeFilter(list, (ObjectTypeFilterSpecification)filter);
        }
    }

    protected void addObjectTypeFilter(List list, ObjectTypeFilterSpecification filter) {
        ArrayList l = new ArrayList();
        ObjectType[] types = filter.getTypes();
        if (types == null || types.length == 0) {
            return;
        }
        Filter[] filters = new Filter[types.length];
        for (int i = 0; i < types.length; ++i) {
            filters[i] = new ObjectTypeFilter(types[i].getQualifiedName());
        }
        if (filter.isExclusion()) {
            list.add(new NegationFilter(new UnionFilter(filters)));
        } else {
            list.add(new UnionFilter(filters));
        }
    }
}

