/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence;

import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.TransactionListener;
import com.arsdigita.util.Assert;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TransactionContext {
    String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/TransactionContext.java#20 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_cat = Logger.getLogger((Class)(class$com$arsdigita$persistence$TransactionContext == null ? (class$com$arsdigita$persistence$TransactionContext = TransactionContext.class$("com.arsdigita.persistence.TransactionContext")) : class$com$arsdigita$persistence$TransactionContext));
    private Session m_ossn;
    com.redhat.persistence.Session m_ssn;
    private Map m_attrs = new HashMap();
    private ArrayList m_listeners = new ArrayList();
    private boolean m_inTxn = false;
    static /* synthetic */ Class class$com$arsdigita$persistence$TransactionContext;

    TransactionContext(Session ssn) {
        this.m_ossn = ssn;
        this.m_ssn = ssn.getProtoSession();
    }

    public void beginTxn() {
        if (this.m_inTxn) {
            throw new IllegalStateException("double begin");
        }
        this.m_inTxn = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTxn() {
        boolean success = false;
        try {
            this.fireBeforeCommitEvent();
            this.m_ssn.flush();
            this.m_ossn.invalidateDataObjects(true, false);
            this.m_ssn.commit();
            success = true;
            this.m_inTxn = false;
            this.fireCommitEvent();
            Object var3_2 = null;
            this.clearAttributes();
            if (!success) {
                this.m_ossn.invalidateDataObjects(false, true);
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.clearAttributes();
            if (!success) {
                this.m_ossn.invalidateDataObjects(false, true);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testCommitTxn(Runnable r) {
        boolean success = false;
        try {
            this.fireBeforeCommitEvent();
            this.m_ssn.flush();
            this.m_ossn.invalidateDataObjects(true, false);
            r.run();
            success = true;
            this.m_inTxn = false;
            this.fireCommitEvent();
            Object var4_3 = null;
            this.clearAttributes();
            if (!success) {
                this.m_ossn.invalidateDataObjects(false, true);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.clearAttributes();
            if (!success) {
                this.m_ossn.invalidateDataObjects(false, true);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTxn() {
        boolean success = false;
        try {
            try {
                this.fireBeforeAbortEvent();
                this.m_ossn.invalidateDataObjects(false, false);
            }
            finally {
                this.m_ssn.rollback();
                this.m_inTxn = false;
            }
            success = true;
            Object var4_3 = null;
            if (!success) {
                this.m_ossn.invalidateDataObjects(false, true);
            }
            this.fireAbortEvent();
            this.clearAttributes();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!success) {
                this.m_ossn.invalidateDataObjects(false, true);
            }
            this.fireAbortEvent();
            this.clearAttributes();
            throw throwable;
        }
    }

    public void addTransactionListener(TransactionListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeTransactionListener(TransactionListener listener) {
        this.m_listeners.remove(listener);
    }

    private void fireBeforeCommitEvent() {
        Assert.assertTrue(this.inTxn(), "The beforeCommit event was fired outside of the transaction");
        Object[] listeners = this.m_listeners.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            if (s_cat.isDebugEnabled()) {
                s_cat.debug((Object)"Firing transaction beforeCommit event");
            }
            TransactionListener listener = (TransactionListener)listeners[i];
            listener.beforeCommit(this);
        }
    }

    private void fireCommitEvent() {
        Assert.assertTrue(!this.inTxn(), "transaction commit event fired during transaction");
        Object[] listeners = this.m_listeners.toArray();
        this.m_listeners.clear();
        for (int i = 0; i < listeners.length; ++i) {
            if (s_cat.isDebugEnabled()) {
                s_cat.debug((Object)"Firing transaction commit event");
            }
            TransactionListener listener = (TransactionListener)listeners[i];
            listener.afterCommit(this);
        }
        Assert.assertTrue(!this.inTxn(), "transaction commit listener didn't close transaction");
    }

    private void fireBeforeAbortEvent() {
        Assert.assertTrue(this.inTxn(), "The beforeAbort event was fired outside of the transaction");
        Object[] listeners = this.m_listeners.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            if (s_cat.isDebugEnabled()) {
                s_cat.debug((Object)"Firing transaction beforeAbort event");
            }
            TransactionListener listener = (TransactionListener)listeners[i];
            listener.beforeAbort(this);
        }
    }

    private void fireAbortEvent() {
        Assert.assertTrue(!this.inTxn(), "transaction abort event fired during transaction");
        Object[] listeners = this.m_listeners.toArray();
        this.m_listeners.clear();
        for (int i = 0; i < listeners.length; ++i) {
            if (s_cat.isDebugEnabled()) {
                s_cat.debug((Object)"Firing transaction abort event");
            }
            TransactionListener listener = (TransactionListener)listeners[i];
            listener.afterAbort(this);
        }
        Assert.assertTrue(!this.inTxn(), "transaction abort listener didn't close transaction");
    }

    public boolean inTxn() {
        return this.m_inTxn;
    }

    public int getTransactionIsolation() {
        try {
            Connection conn = this.m_ossn.getConnection();
            return conn.getTransactionIsolation();
        }
        catch (SQLException e) {
            throw PersistenceException.newInstance(e);
        }
    }

    public void setTransactionIsolation(int level) {
        try {
            Connection conn = this.m_ossn.getConnection();
            conn.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            throw PersistenceException.newInstance(e);
        }
    }

    public void setAttribute(String name, Object value) {
        this.m_attrs.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.m_attrs.get(name);
    }

    public void removeAttribute(String name) {
        this.m_attrs.remove(name);
    }

    void clearAttributes() {
        this.m_attrs.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

