/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence;

import com.arsdigita.db.DbHelper;
import com.arsdigita.persistence.ConnectionSource;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.versioning.Versions;
import com.redhat.persistence.EventProcessorManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SessionManager {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/SessionManager.java#17 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((String)(class$com$arsdigita$persistence$SessionManager == null ? (class$com$arsdigita$persistence$SessionManager = SessionManager.class$("com.arsdigita.persistence.SessionManager")) : class$com$arsdigita$persistence$SessionManager).getName());
    private static Set s_beforeFlushProcManagers = new HashSet();
    private static Set s_afterFlushProcManagers;
    private static Map s_configurations;
    private static ThreadLocal s_sessions;
    static /* synthetic */ Class class$com$arsdigita$persistence$SessionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(String name, MetadataRoot root, ConnectionSource source) {
        Map map = s_configurations;
        synchronized (map) {
            if (s_configurations.containsKey(name)) {
                throw new IllegalArgumentException("already configured: " + name);
            }
            s_configurations.put(name, new Config(name, root, source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session open(String name, MetadataRoot root, ConnectionSource source) {
        EventProcessorManager mngr;
        int database;
        if (SessionManager.hasSession(name)) {
            throw new IllegalStateException("session already open: " + name);
        }
        Connection conn = source.acquire();
        try {
            try {
                database = DbHelper.getDatabaseFromURL(conn.getMetaData().getURL());
            }
            catch (SQLException e) {
                throw new UncheckedWrapperException(e);
            }
        }
        finally {
            source.release(conn);
        }
        Session result = new Session(root, source, database);
        Iterator ii = s_beforeFlushProcManagers.iterator();
        while (ii.hasNext()) {
            mngr = (EventProcessorManager)ii.next();
            result.getProtoSession().addBeforeFlush(mngr.getEventProcessor());
        }
        ii = s_afterFlushProcManagers.iterator();
        while (ii.hasNext()) {
            mngr = (EventProcessorManager)ii.next();
            result.getProtoSession().addAfterFlush(mngr.getEventProcessor());
        }
        SessionManager.setSession(name, result);
        return result;
    }

    public static Session getSession() {
        return SessionManager.getSession("default");
    }

    private static Map getSessions() {
        return (Map)s_sessions.get();
    }

    private static void setSession(String name, Session ssn) {
        SessionManager.getSessions().put(name, ssn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession(String name) {
        Map map = SessionManager.getSessions();
        if (!map.containsKey(name)) {
            Map map2 = s_configurations;
            synchronized (map2) {
                Config conf = (Config)s_configurations.get(name);
                if (conf == null) {
                    return null;
                }
                return SessionManager.open(name, conf.getRoot(), conf.getSource());
            }
        }
        return (Session)map.get(name);
    }

    public static boolean hasSession(String name) {
        return SessionManager.getSessions().containsKey(name);
    }

    public static synchronized void addBeforeFlushProcManager(EventProcessorManager manager) {
        s_beforeFlushProcManagers.add(manager);
    }

    public static synchronized void addAfterFlushProcManager(EventProcessorManager manager) {
        s_afterFlushProcManagers.add(manager);
    }

    public static MetadataRoot getMetadataRoot() {
        return SessionManager.getSession().getMetadataRoot();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SessionManager.addBeforeFlushProcManager(Versions.EPM);
        s_afterFlushProcManagers = new HashSet();
        s_configurations = new HashMap();
        s_sessions = new ThreadLocal(){

            public Object initialValue() {
                return new HashMap();
            }
        };
    }

    private static class Config {
        private String m_name;
        private MetadataRoot m_root;
        private ConnectionSource m_source;

        public Config(String name, MetadataRoot root, ConnectionSource source) {
            this.m_name = name;
            this.m_root = root;
            this.m_source = source;
        }

        public String getName() {
            return this.m_name;
        }

        public MetadataRoot getRoot() {
            return this.m_root;
        }

        public ConnectionSource getSource() {
            return this.m_source;
        }
    }
}

