/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.persistence;

import com.arsdigita.persistence.DataQueryImpl;
import com.arsdigita.persistence.EqualsFilter;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.InFilter;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SimpleFilter;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.oql.Expression;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

abstract class FilterImpl
implements Filter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/persistence/FilterImpl.java#18 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger m_log = Logger.getLogger((String)(class$com$arsdigita$persistence$Filter == null ? (class$com$arsdigita$persistence$Filter = FilterImpl.class$("com.arsdigita.persistence.Filter")) : class$com$arsdigita$persistence$Filter).getName());
    private Map m_bindings = new HashMap();
    static /* synthetic */ Class class$com$arsdigita$persistence$Filter;

    protected FilterImpl() {
    }

    public abstract String getConditions();

    protected abstract Expression makeExpression(DataQueryImpl var1, Map var2);

    static final String bindName(String propertyName) {
        StringBuffer result = new StringBuffer(propertyName.length());
        block4: for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            switch (c) {
                case '.': {
                    result.append('_');
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '(': 
                case ')': {
                    continue block4;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    static String createNullString(String comparator, String variableName) {
        if (comparator.indexOf("!") > -1 || comparator.indexOf("<>") > -1) {
            return variableName + " is not null";
        }
        return variableName + " is null";
    }

    public static Filter simple(String conditions) {
        if (conditions == null || conditions.equals("")) {
            throw new PersistenceException("The filter conditions must not be null or the empty string");
        }
        return new SimpleFilter(conditions);
    }

    private static Filter filterForNullValue(String attribute, boolean trueForAllIfValueIsNull) {
        if (trueForAllIfValueIsNull) {
            return new SimpleFilter(null);
        }
        return FilterImpl.simple(FilterImpl.createNullString("!=", attribute) + " and " + FilterImpl.createNullString("=", attribute));
    }

    protected static Filter equals(String attribute, Object value) {
        return EqualsFilter.eq(attribute, value);
    }

    protected static Filter notEquals(String attribute, Object value) {
        return EqualsFilter.notEq(attribute, value);
    }

    protected static Filter lessThan(String attribute, Object value, boolean trueForAllIfValueIsNull) {
        return FilterImpl.createComparisonFilter(attribute, value, trueForAllIfValueIsNull, "<");
    }

    protected static Filter lessThanEquals(String attribute, Object value, boolean trueForAllIfValueIsNull) {
        return FilterImpl.createComparisonFilter(attribute, value, trueForAllIfValueIsNull, "<=");
    }

    protected static Filter greaterThan(String attribute, Object value, boolean trueForAllIfValueIsNull) {
        return FilterImpl.createComparisonFilter(attribute, value, trueForAllIfValueIsNull, ">");
    }

    protected static Filter greaterThanEquals(String attribute, Object value, boolean trueForAllIfValueIsNull) {
        return FilterImpl.createComparisonFilter(attribute, value, trueForAllIfValueIsNull, ">=");
    }

    private static Filter createComparisonFilter(String attribute, Object value, boolean trueForAllIfValueIsNull, String comparator) {
        if (value == null) {
            return FilterImpl.filterForNullValue(attribute, trueForAllIfValueIsNull);
        }
        String bind = FilterImpl.bindName(attribute);
        Filter filter = FilterImpl.simple(attribute + " " + comparator + " :" + bind);
        filter.set(bind, value);
        return filter;
    }

    protected static Filter startsWith(String attribute, String value, boolean trueForAllIfValueIsNull) {
        if (value == null) {
            return FilterImpl.filterForNullValue(attribute, trueForAllIfValueIsNull);
        }
        String bind = FilterImpl.bindName(attribute);
        Filter filter = FilterImpl.simple(attribute + " like :" + bind + " || '%'");
        filter.set(bind, value);
        return filter;
    }

    protected static Filter endsWith(String attribute, String value, boolean trueForAllIfValueIsNull) {
        if (value == null) {
            return FilterImpl.filterForNullValue(attribute, trueForAllIfValueIsNull);
        }
        String bind = FilterImpl.bindName(attribute);
        Filter filter = FilterImpl.simple(attribute + " like '%' || :" + bind);
        filter.set(bind, value);
        return filter;
    }

    protected static Filter contains(String attribute, String value, boolean trueForAllIfValueIsNull) {
        if (value == null) {
            return FilterImpl.filterForNullValue(attribute, trueForAllIfValueIsNull);
        }
        String bind = FilterImpl.bindName(attribute);
        Filter filter = FilterImpl.simple(attribute + " like '%' || :" + bind + " || '%'");
        filter.set(bind, value);
        return filter;
    }

    protected static Filter in(Root root, String propertyName, String queryName) {
        if (propertyName == null || propertyName.equals("") || queryName == null || queryName.equals("")) {
            throw new IllegalArgumentException("The propertyName and queryName must be non empty.");
        }
        return new InFilter(root, propertyName, null, queryName);
    }

    protected static Filter in(Root root, String property, String subQueryProperty, String queryName) {
        if (property == null || property.equals("") || subQueryProperty == null || subQueryProperty.equals("") || queryName == null || queryName.equals("")) {
            throw new IllegalArgumentException("The property, subQueryProperty and queryName must be non empty.");
        }
        return new InFilter(root, property, subQueryProperty, queryName);
    }

    protected static Filter notIn(Root root, String propertyName, String queryName) {
        if (propertyName == null || propertyName.equals("") || queryName == null || queryName.equals("")) {
            throw new IllegalArgumentException("The propertyName and queryName must be non empty.");
        }
        InFilter in = new InFilter(root, propertyName, null, queryName);
        return new SimpleFilter("not " + in.getConditions());
    }

    public Filter set(String parameterName, Object value) {
        if (this.m_bindings.containsKey(parameterName) && m_log.isEnabledFor((Priority)Level.WARN)) {
            m_log.warn((Object)("The existing filter already contains a parameter named \"" + parameterName + "\".  Overwriting the" + " the old value " + this.m_bindings.get(parameterName) + " with " + value));
        }
        this.m_bindings.put(parameterName, value);
        return this;
    }

    public Map getBindings() {
        return this.m_bindings;
    }

    protected void addBinding(String key, Object value) {
        this.m_bindings.put(key, value);
    }

    protected void addBindings(Map bindings) {
        this.m_bindings.putAll(bindings);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

