/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.packaging;

import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterContext;
import com.arsdigita.util.parameter.ParameterReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class ParameterMap {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/ParameterMap.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private List m_contexts = new ArrayList();
    private List m_parameters = new ArrayList();
    private Map m_containers = new HashMap();
    private Map m_parametersByName = new HashMap();

    ParameterMap() {
    }

    public void addContext(ParameterContext context) {
        this.m_contexts.add(context);
        Parameter[] params = context.getParameters();
        for (int i = 0; i < params.length; ++i) {
            this.m_parameters.add(params[i]);
            this.m_containers.put(params[i], context);
            this.m_parametersByName.put(params[i].getName(), params[i]);
        }
    }

    public void addContexts(Collection contexts) {
        Iterator it = contexts.iterator();
        while (it.hasNext()) {
            this.addContext((ParameterContext)it.next());
        }
    }

    public List getContexts() {
        return this.m_contexts;
    }

    public List getParameters() {
        return this.m_parameters;
    }

    public Parameter getParameter(String name) {
        return (Parameter)this.m_parametersByName.get(name);
    }

    public ParameterContext getContainer(Parameter param) {
        return (ParameterContext)this.m_containers.get(param);
    }

    public Object get(Parameter param) {
        return this.getContainer(param).get(param);
    }

    public void set(Parameter param, Object obj) {
        this.getContainer(param).set(param, obj);
    }

    public void validate(ErrorList errs) {
        Iterator it = this.getContexts().iterator();
        while (it.hasNext()) {
            ParameterContext ctx = (ParameterContext)it.next();
            ctx.validate(errs);
        }
    }

    public boolean validate(PrintStream out) {
        ErrorList errs = new ErrorList();
        this.validate(errs);
        if (errs.isEmpty()) {
            return true;
        }
        out.println(" *** Error ***");
        errs.report(new OutputStreamWriter(out));
        return false;
    }

    public void load(ParameterReader reader, ErrorList errs) {
        Iterator it = this.getContexts().iterator();
        while (it.hasNext()) {
            ParameterContext ctx = (ParameterContext)it.next();
            ctx.load(reader, errs);
        }
    }

    public boolean load(ParameterReader reader, PrintStream out) {
        ErrorList errs = new ErrorList();
        this.load(reader, errs);
        if (errs.isEmpty()) {
            return true;
        }
        out.println(" *** Error ***");
        errs.report(new OutputStreamWriter(out));
        return false;
    }
}

