/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.metadata;

import com.arsdigita.db.ConnectionManager;
import com.arsdigita.db.Sequences;
import com.arsdigita.metadata.DynamicElement;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.Association;
import com.arsdigita.persistence.metadata.Utilities;
import com.arsdigita.util.Assert;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.metadata.ForeignKey;
import com.redhat.persistence.metadata.JoinThrough;
import com.redhat.persistence.metadata.Model;
import com.redhat.persistence.metadata.ObjectMap;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Role;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.UniqueKey;
import com.redhat.persistence.pdl.PDLWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class DynamicAssociation
extends DynamicElement {
    private Model m_model;
    private Property m_prop1;
    private Property m_prop2;
    private Root m_root = SessionManager.getSession().getMetadataRoot().getRoot();
    private DataObject m_dataObject = null;
    private static final String objectTypeString = "com.arsdigita.persistence.DynamicAssociation";
    private static final int COLLECTION = 2;
    private static final int NULLABLE = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicAssociation(String modelName, String objectType1, String property1, String objectType2, String property2) {
        Model model = Model.getInstance(modelName);
        ObjectType type1 = this.m_root.getObjectType(objectType1);
        ObjectType type2 = this.m_root.getObjectType(objectType2);
        if (type1 == null) {
            throw new PersistenceException(objectType1 + " does not exist");
        }
        if (type2 == null) {
            throw new PersistenceException(objectType2 + " does not exist");
        }
        Role prop1 = (Role)type2.getProperty(property1);
        Role prop2 = (Role)type1.getProperty(property2);
        if (prop1 == null || prop2 == null) {
            throw new PersistenceException("Either " + property1 + " or " + property2 + " is null");
        }
        if (!prop1.isReversable() || !prop2.isReversable()) {
            throw new PersistenceException("Either " + property1 + " or " + property2 + " does not " + "belong to an association");
        }
        if (!prop1.getReverse().equals(prop2)) {
            throw new PersistenceException("Properties belong to different associations");
        }
        this.m_prop1 = prop1;
        this.m_prop2 = prop2;
        this.m_model = model;
        DataCollection collection = SessionManager.getSession().retrieve(objectTypeString);
        collection.addEqualsFilter("modelName", model.getQualifiedName());
        collection.addEqualsFilter("property1", prop1.getName());
        collection.addEqualsFilter("objectType1", prop1.getType().getQualifiedName());
        collection.addEqualsFilter("property2", prop2.getName());
        collection.addEqualsFilter("objectType2", prop2.getType().getQualifiedName());
        try {
            if (!collection.next()) {
                throw new PersistenceException("The association you have requsted is static, and thus cannot be used as a dynamic association");
            }
            this.m_dataObject = collection.getDataObject();
        }
        finally {
            collection.close();
        }
    }

    public DynamicAssociation(String modelName, String objectType1, String property1, int multiplicity1, String objectType2, String property2, int multiplicity2) {
        Model model = Model.getInstance(modelName);
        ObjectType type1 = this.m_root.getObjectType(objectType1);
        ObjectType type2 = this.m_root.getObjectType(objectType2);
        if (type1 == null) {
            throw new PersistenceException(objectType1 + " does not exist");
        }
        if (type2 == null) {
            throw new PersistenceException(objectType2 + " does not exist");
        }
        Role prop1 = (Role)type1.getProperty(property1);
        Role prop2 = (Role)type2.getProperty(property2);
        if (prop1 != null || prop2 != null) {
            throw new PersistenceException("Either " + property1 + " or " + property2 + " is not null");
        }
        prop1 = new Role(property1, type1, false, multiplicity1 == 2, multiplicity1 == 0);
        prop2 = new Role(property2, type2, false, multiplicity2 == 2, multiplicity2 == 0);
        prop1.setReverse(prop2);
        this.m_prop1 = prop1;
        this.m_prop2 = prop2;
        this.m_model = model;
    }

    public com.arsdigita.persistence.metadata.Property getProperty1() {
        return DynamicAssociation.property(this.m_prop1);
    }

    public com.arsdigita.persistence.metadata.Property getProperty2() {
        return DynamicAssociation.property(this.m_prop2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Association save() {
        ObjectType type1 = this.m_prop1.getType();
        ObjectType type2 = this.m_prop2.getType();
        if (this.m_dataObject == null) {
            ObjectMap om1 = this.m_root.getObjectMap(type1);
            ObjectMap om2 = this.m_root.getObjectMap(type2);
            UniqueKey from = om2.getTable().getPrimaryKey();
            UniqueKey to = om1.getTable().getPrimaryKey();
            if (from == null) throw new PersistenceException("One of the object type tables does not have a key.");
            if (to == null) {
                throw new PersistenceException("One of the object type tables does not have a key.");
            }
            Property p2 = type1.getProperty(this.m_prop2.getName());
            Property p1 = type2.getProperty(this.m_prop1.getName());
            Assert.assertTrue(p2 == null || p2 == this.m_prop2);
            Assert.assertTrue(p1 == null || p1 == this.m_prop1);
            if (p2 == null) {
                type1.addProperty(this.m_prop2);
            }
            if (p1 == null) {
                type2.addProperty(this.m_prop1);
            }
            Table mappingTable = new Table(DynamicAssociation.generateTableName(this.m_prop1));
            this.m_root.addTable(mappingTable);
            ForeignKey fromKey = DynamicAssociation.fk(mappingTable, "from", from);
            ForeignKey toKey = DynamicAssociation.fk(mappingTable, "to", to);
            om2.addMapping(new JoinThrough(Path.get(this.m_prop1.getName()), fromKey, toKey));
            om1.addMapping(new JoinThrough(Path.get(this.m_prop2.getName()), toKey, fromKey));
            String ddl = mappingTable.getSQL(false);
            Statement statement = null;
            Connection conn = null;
            try {
                try {
                    conn = ConnectionManager.getConnection();
                    statement = conn.createStatement();
                    statement.executeUpdate(ddl);
                }
                catch (SQLException e) {
                    throw PersistenceException.newInstance(e.getMessage() + Utilities.LINE_BREAK + "SQL for ADD: " + ddl, e);
                }
                Object var17_16 = null;
                {
                }
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                try {
                    if (conn != null) {
                        ConnectionManager.returnConnection(conn);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                catch (SQLException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException ignored) {}
            if (conn != null) {
                ConnectionManager.returnConnection(conn);
            }
            if (statement != null) {
                statement.close();
            }
        }
        StringWriter sw = new StringWriter();
        PDLWriter pw = new PDLWriter(sw);
        pw.writeAssociation(this.m_prop1);
        String pdl = "model " + this.m_model.getQualifiedName() + ";" + Utilities.LINE_BREAK + sw.toString();
        try {
            if (this.m_dataObject == null) {
                this.m_dataObject = SessionManager.getSession().create(objectTypeString);
                this.m_dataObject.set("id", Sequences.getNextValue());
                this.m_dataObject.set("objectType", objectTypeString);
                this.m_dataObject.set("displayName", objectTypeString);
                this.m_dataObject.set("modelName", this.m_model.getQualifiedName());
                this.m_dataObject.set("property1", this.m_prop1.getName());
                this.m_dataObject.set("objectType1", type1.getQualifiedName());
                this.m_dataObject.set("property2", this.m_prop2.getName());
                this.m_dataObject.set("objectType2", type2.getQualifiedName());
            }
            this.m_dataObject.set("pdlFile", pdl);
            this.m_dataObject.save();
            return this.getProperty1().getAssociation();
        }
        catch (SQLException e) {
            throw PersistenceException.newInstance("Error saving PDL file", e);
        }
    }
}

