/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.mail;

import com.arsdigita.mail.ByteArrayDataSource;
import com.arsdigita.mail.MailConfig;
import com.arsdigita.mail.MimeMessage;
import com.arsdigita.util.MessageType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.log4j.Logger;

public class Mail
implements MessageType {
    private static final MailConfig s_config = new MailConfig();
    private static final InternetAddress[] EMPTY_ADDRESS_LIST;
    private Hashtable m_headers;
    private InternetAddress[] m_to;
    private InternetAddress[] m_filteredTo = EMPTY_ADDRESS_LIST;
    private InternetAddress[] m_invalidTo = EMPTY_ADDRESS_LIST;
    private static Set s_invalidDomains;
    private InternetAddress m_from;
    private InternetAddress[] m_replyTo;
    private InternetAddress[] m_cc;
    private InternetAddress[] m_bcc;
    private String m_subject;
    private String m_body;
    private String m_alternate;
    private String m_encoding;
    private MimeMultipart m_attachments;
    private String m_messageID;
    private static Session s_session;
    private static String s_host;
    private static String s_port;
    static final String CONTENT_TYPE = "Content-Type";
    static final String CONTENT_ID = "Content-ID";
    static final String MIXED = "mixed";
    static final String ALTERNATIVE = "alternative";
    public static final String INLINE = "inline";
    public static final String ATTACHMENT = "attachment";
    private static final Logger s_log;
    static /* synthetic */ Class class$com$arsdigita$mail$Mail;

    static MailConfig getConfig() {
        return s_config;
    }

    public Mail() {
        this(null, null, null, null);
    }

    public Mail(String to, String from, String subject) {
        this(to, from, subject, null);
    }

    public Mail(String to, String from, String subject, String body) {
        this.m_to = to == null ? EMPTY_ADDRESS_LIST : Mail.parseAddressField(to);
        this.filterRecipients();
        this.m_from = from == null ? null : Mail.parseAddress(from);
        this.m_subject = subject;
        this.setBody(body);
    }

    public Mail(String to, String from, String subject, String body, String enc) {
        this(to, from, subject, body);
        this.setEncoding(enc);
    }

    public static void send(String to, String from, String subject, String body) throws MessagingException, SendFailedException {
        Mail msg = new Mail(to, from, subject, body);
        msg.send();
    }

    public void send() throws MessagingException, SendFailedException {
        Transport transport = Mail.getSession().getTransport();
        transport.connect();
        this.send(transport);
        transport.close();
    }

    void send(Transport transport) throws MessagingException, SendFailedException {
        Message msg = null;
        if (this.m_filteredTo.length > 0) {
            msg = this.getMessage();
            try {
                transport.sendMessage(msg, msg.getAllRecipients());
            }
            catch (MessagingException mex) {
                transport.close();
                throw new SendFailedException("send failed: ", (Exception)((Object)mex));
            }
        }
        if (s_config.isDebug()) {
            if (msg != null) {
                try {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    msg.writeTo((OutputStream)os);
                    s_log.debug((Object)("message sent:\n" + os.toString() + "\n-- EOT --"));
                }
                catch (IOException ex) {
                    s_log.error((Object)"unable to log message");
                }
            } else {
                s_log.debug((Object)"no message sent. No valid recipients:\n");
            }
        } else {
            s_log.info((Object)("message sent to <" + this.m_filteredTo + "> from <" + this.m_from + "> subject <" + this.m_subject + ">"));
            s_log.info((Object)("messages filtered for <" + this.m_invalidTo + "> from <" + this.m_from + "> subject <" + this.m_subject + ">"));
        }
    }

    public void setTo(String to) {
        this.m_to = Mail.parseAddressField(to);
        this.filterRecipients();
    }

    public void setFrom(String from) {
        this.m_from = Mail.parseAddress(from);
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    public void setReplyTo(String replyTo) {
        this.m_replyTo = Mail.parseAddressField(replyTo);
    }

    public void setMessageID(String messageID) {
        this.m_messageID = messageID;
    }

    public void setHeaders(String headers) {
        this.m_headers = Mail.parseHeaderField(headers);
    }

    public void addHeader(String name, String value) {
        if (this.m_headers == null) {
            this.m_headers = new Hashtable();
        }
        this.m_headers.put(name, value);
    }

    public void setCc(String cc) {
        this.m_cc = Mail.parseAddressField(cc);
    }

    public void setBcc(String bcc) {
        this.m_bcc = Mail.parseAddressField(bcc);
    }

    public void setBody(String body) {
        this.m_body = body;
    }

    public void setBody(String body, String alt) {
        this.m_body = body;
        this.m_alternate = alt;
    }

    public void setEncoding(String enc) {
        this.m_encoding = enc;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    private void attach(MimeBodyPart part) throws MessagingException {
        if (this.m_attachments == null) {
            this.m_attachments = new MimeMultipart();
        }
        this.m_attachments.addBodyPart((BodyPart)part);
    }

    public void attach(URL url, String name, String description) throws MessagingException {
        this.attach(url, name, description, ATTACHMENT);
    }

    public void attach(URL url, String name, String description, String disposition) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        this.attach(part);
        DataHandler dh = new DataHandler((DataSource)new URLDataSource(url));
        part.setDataHandler(dh);
        part.setFileName(name);
        part.setDescription(description);
        part.setDisposition(disposition);
    }

    public void attach(File path, String name, String description) throws MessagingException {
        this.attach(path, name, description, ATTACHMENT);
    }

    public void attach(File path, String name, String description, String disposition) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        this.attach(part);
        DataHandler dh = new DataHandler((DataSource)new FileDataSource(path));
        part.setDataHandler(dh);
        part.setFileName(name);
        part.setDescription(description);
        part.setDisposition(disposition);
    }

    public void attach(byte[] data, String type, String name) throws MessagingException {
        this.attach(data, type, name, null, ATTACHMENT);
    }

    public void attach(byte[] data, String type, String name, String description, String disposition) throws MessagingException {
        ByteArrayDataSource ds = new ByteArrayDataSource(data, type, name);
        this.attach(ds, description, disposition);
    }

    public void attach(String data, String type, String name) throws MessagingException {
        this.attach(data, type, name, null, ATTACHMENT);
    }

    public void attach(String data, String type, String name, String description, String disposition) throws MessagingException {
        ByteArrayDataSource ds = new ByteArrayDataSource(data, type, name);
        this.attach(ds, description, disposition);
    }

    public void attach(ByteArrayInputStream is, String type, String name) throws MessagingException {
        this.attach(is, type, name, null, ATTACHMENT);
    }

    public void attach(ByteArrayInputStream is, String type, String name, String description, String disposition) throws MessagingException {
        ByteArrayDataSource ds = new ByteArrayDataSource(is, type, name);
        this.attach(ds, description, disposition);
    }

    protected void attach(ByteArrayDataSource dataSource, String description, String disposition) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        this.attach(part);
        DataHandler dh = new DataHandler((DataSource)dataSource);
        part.setDataHandler(dh);
        part.setFileName(dataSource.getName());
        part.setDescription(description);
        part.setDisposition(disposition);
    }

    public void attach(DataHandler dh) throws MessagingException {
        this.attach(dh, null, ATTACHMENT);
    }

    public void attach(DataHandler dh, String description, String disposition) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        this.attach(part);
        part.setDataHandler(dh);
        part.setFileName(dh.getName());
        part.setDescription(description);
        part.setDisposition(disposition);
    }

    static synchronized Session getSession() {
        if (s_session == null) {
            Properties props = new Properties(s_config.getJavamail());
            if (s_host != null) {
                props.put("mail.smtp.host", s_host);
            }
            if (s_port != null) {
                props.put("mail.smtp.port", s_port);
            }
            s_session = Session.getInstance((Properties)props, null);
            s_session.setDebug(s_config.isDebug());
        }
        return s_session;
    }

    private Message getMessage() throws MessagingException {
        String enc_subj;
        MimeMessage msg = new MimeMessage(Mail.getSession());
        msg.setFrom((Address)this.m_from);
        msg.setRecipients(Message.RecipientType.TO, (Address[])this.m_filteredTo);
        msg.setSentDate(new Date());
        if (this.m_messageID != null) {
            msg.setMessageID("<" + this.m_messageID + ">");
        }
        if (this.m_cc != null) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])this.m_cc);
        }
        if (this.m_bcc != null) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])this.m_bcc);
        }
        if (this.m_replyTo != null) {
            msg.setReplyTo((Address[])this.m_replyTo);
        }
        try {
            enc_subj = MimeUtility.encodeText((String)this.m_subject, (String)this.m_encoding, null);
        }
        catch (UnsupportedEncodingException uee) {
            s_log.warn((Object)("unable to encode subject: " + uee));
            enc_subj = this.m_subject;
        }
        msg.setSubject(enc_subj);
        if (this.m_headers != null) {
            Enumeration e = this.m_headers.keys();
            while (e.hasMoreElements()) {
                String enc_v;
                String name = (String)e.nextElement();
                String value = (String)this.m_headers.get(name);
                try {
                    enc_v = MimeUtility.encodeText((String)value, (String)this.m_encoding, null);
                }
                catch (UnsupportedEncodingException uee) {
                    s_log.warn((Object)("unable to encode header element: " + uee));
                    enc_v = value;
                }
                msg.addHeader(name, enc_v);
            }
        }
        return this.prepareMessageContent(msg);
    }

    static synchronized void setSmtpServer(String host, String port) {
        s_host = host;
        s_port = port;
        s_session = null;
    }

    public static synchronized String getSmtpServer() {
        return s_host;
    }

    public void writeTo(OutputStream os) throws MessagingException {
        try {
            this.getMessage().writeTo(os);
        }
        catch (IOException ex) {
            s_log.error((Object)"writeTo output error", (Throwable)ex);
        }
    }

    private static InternetAddress[] parseAddressField(String str) {
        String[] addrList;
        if (str.indexOf(",") != -1) {
            ArrayList<String> a = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(str, ",", false);
            while (st.hasMoreTokens()) {
                a.add(st.nextToken());
            }
            addrList = new String[a.size()];
            a.toArray(addrList);
        } else {
            addrList = new String[]{str};
        }
        return Mail.parseAddressList(addrList);
    }

    private static InternetAddress[] parseAddressList(String[] addrList) {
        InternetAddress[] addrs = new InternetAddress[addrList.length];
        for (int i = 0; i < addrList.length; ++i) {
            addrs[i] = Mail.parseAddress(addrList[i]);
        }
        return addrs;
    }

    private static InternetAddress parseAddress(String str) {
        String address = null;
        String personal = null;
        InternetAddress addr = null;
        if ((str = str.trim()).indexOf(" ") == -1) {
            address = str;
        } else {
            int sp = str.lastIndexOf(" ");
            personal = str.substring(0, sp);
            address = str.substring(sp + 1);
        }
        try {
            addr = new InternetAddress(address, personal);
        }
        catch (UnsupportedEncodingException e) {
            s_log.error((Object)("unable to parse address: " + str));
        }
        return addr;
    }

    private static Hashtable parseHeaderField(String str) {
        String[] headerList;
        if (str.indexOf(",") != -1) {
            ArrayList<String> a = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(str, ",", false);
            while (st.hasMoreTokens()) {
                a.add(st.nextToken());
            }
            headerList = new String[a.size()];
            a.toArray(headerList);
        } else {
            headerList = new String[]{str};
        }
        return Mail.parseHeaderList(headerList);
    }

    private static Hashtable parseHeaderList(String[] headerList) {
        Hashtable headers = new Hashtable();
        for (int i = 0; i < headerList.length; ++i) {
            Mail.parseHeader(headerList[i], headers);
        }
        return headers;
    }

    private static void parseHeader(String str, Hashtable headers) {
        str = str.trim();
        int sp = str.lastIndexOf(":");
        String name = str.substring(0, sp);
        String value = str.substring(sp + 1).trim();
        headers.put(name, value);
    }

    private Message prepareMessageContent(MimeMessage msg) throws MessagingException {
        if (this.m_alternate == null && this.m_attachments == null) {
            msg.setText(this.m_body, this.m_encoding);
        } else {
            String subtype = this.m_attachments == null ? ALTERNATIVE : MIXED;
            MimeMultipart mp = new MimeMultipart(subtype);
            msg.setContent((Multipart)mp);
            MimeBodyPart part = new MimeBodyPart();
            if (this.m_alternate == null) {
                part.setText(this.m_body, this.m_encoding);
                part.setHeader(CONTENT_TYPE, "text/plain");
                mp.addBodyPart((BodyPart)part);
            } else {
                part.setText(this.m_body, this.m_encoding);
                part.setHeader(CONTENT_TYPE, "text/html");
                mp.addBodyPart((BodyPart)part);
                part = new MimeBodyPart();
                part.setText(this.m_alternate, this.m_encoding);
                part.setHeader(CONTENT_TYPE, "text/plain");
                mp.addBodyPart((BodyPart)part);
            }
            if (this.m_attachments != null) {
                for (int i = 0; i < this.m_attachments.getCount(); ++i) {
                    mp.addBodyPart(this.m_attachments.getBodyPart(i));
                }
            }
        }
        msg.saveChanges();
        return msg;
    }

    private InternetAddress[] filterRecipients() {
        ArrayList<InternetAddress> filtered = new ArrayList<InternetAddress>();
        ArrayList<InternetAddress> invalid = new ArrayList<InternetAddress>();
        for (int i = 0; i < this.m_to.length; ++i) {
            Iterator it = s_invalidDomains.iterator();
            boolean isValid = true;
            while (it.hasNext()) {
                if (!this.m_to[i].getAddress().endsWith((String)it.next())) continue;
                isValid = false;
                break;
            }
            if (isValid) {
                filtered.add(this.m_to[i]);
                continue;
            }
            invalid.add(this.m_to[i]);
            s_log.debug((Object)("filtering message to non-existent email address " + this.m_to[i]));
        }
        this.m_filteredTo = filtered.toArray(new InternetAddress[filtered.size()]);
        this.m_invalidTo = invalid.toArray(new InternetAddress[invalid.size()]);
        return this.m_filteredTo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_config.load("ccm-core/mail.properties");
        s_config.require("javamail.properties");
        EMPTY_ADDRESS_LIST = new InternetAddress[0];
        s_invalidDomains = new HashSet();
        s_invalidDomains.add("example.com");
        s_log = Logger.getLogger((Class)(class$com$arsdigita$mail$Mail == null ? (class$com$arsdigita$mail$Mail = Mail.class$("com.arsdigita.mail.Mail")) : class$com$arsdigita$mail$Mail));
    }
}

