/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.kernel.permissions;

import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;

public class PermissionDescriptor {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/permissions/PermissionDescriptor.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private OID m_partyOID;
    private OID m_acsObjectOID;
    private PrivilegeDescriptor m_privilege;

    public PermissionDescriptor(PrivilegeDescriptor privilege, ACSObject acsObject, Party party) {
        Assert.assertNotNull(acsObject, "ACSObject acsObject");
        this.m_partyOID = party != null ? party.getOID() : null;
        this.m_acsObjectOID = acsObject.getOID();
        Assert.assertNotNull(privilege, "privilege");
        this.m_privilege = privilege;
    }

    public PermissionDescriptor(PrivilegeDescriptor privilege, OID acsObjectOID, OID partyOID) {
        if (partyOID != null) {
            try {
                ObjectType.verifySubtype("com.arsdigita.kernel.Party", partyOID.getObjectType());
            }
            catch (RuntimeException e) {
                throw new UncheckedWrapperException("The OID for the Party has an invalid object type.\nExpecting: com.arsdigita.kernel.Party\nActual: " + partyOID.getObjectType().getQualifiedName(), e);
            }
        }
        this.m_partyOID = partyOID;
        try {
            ObjectType.verifySubtype("com.arsdigita.kernel.ACSObject", acsObjectOID.getObjectType());
        }
        catch (RuntimeException e) {
            throw new UncheckedWrapperException("The OID for the ACSObject has an invalid object type.\nExpecting: com.arsdigita.kernel.ACSObject \nActual: " + acsObjectOID.getObjectType().getQualifiedName(), e);
        }
        this.m_acsObjectOID = acsObjectOID;
        Assert.assertNotNull(privilege, "privilege");
        this.m_privilege = privilege;
    }

    public OID getPartyOID() {
        return this.m_partyOID;
    }

    public OID getACSObjectOID() {
        return this.m_acsObjectOID;
    }

    public PrivilegeDescriptor getPrivilegeDescriptor() {
        return this.m_privilege;
    }

    public boolean equals(Object o) {
        PermissionDescriptor p = (PermissionDescriptor)o;
        return this.getACSObjectOID().equals(p.getACSObjectOID()) && (this.getPartyOID() == null && p.getPartyOID() == null || this.getPartyOID() != null && p.getPartyOID() != null && this.getPartyOID().equals(p.getPartyOID())) && this.getPrivilegeDescriptor().equals(p.getPrivilegeDescriptor());
    }

    public int hashCode() {
        return this.getPartyOID().hashCode() + this.getACSObjectOID().hashCode() + this.getPrivilegeDescriptor().hashCode();
    }
}

