/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.initializer;

import com.arsdigita.initializer.InitializationException;
import com.arsdigita.initializer.Initializer;
import com.arsdigita.initializer.InitializerErrorReport;
import com.arsdigita.initializer.ParseException;
import com.arsdigita.initializer.ScriptParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class Script {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/initializer/Script.java#21 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$initializer$Script == null ? (class$com$arsdigita$initializer$Script = Script.class$("com.arsdigita.initializer.Script")) : class$com$arsdigita$initializer$Script));
    private Map m_initMap = new HashMap();
    private List m_initializers = new ArrayList();
    private String m_lastInitializerToRun;
    private boolean m_isStarted = false;
    private boolean m_isShutdown = false;
    static /* synthetic */ Class class$com$arsdigita$initializer$Script;
    static /* synthetic */ Class class$com$arsdigita$initializer$GenericInitializer;

    public Script(StringBuffer bs) throws InitializationException {
        this(bs, null);
    }

    public Script(StringBuffer bs, String iniName) throws InitializationException {
        this((Reader)new StringReader(bs.toString()), iniName);
    }

    public Script(String s) throws InitializationException {
        this(s, null);
    }

    public Script(String s, String iniName) throws InitializationException {
        this((Reader)new StringReader(s), iniName);
    }

    public Script(InputStream is) throws InitializationException {
        this(is, null);
    }

    public Script(InputStream is, String iniName) throws InitializationException {
        this((Reader)new InputStreamReader(is), iniName);
    }

    public Script(Reader r) throws InitializationException {
        this(r, null);
    }

    public Script(Reader r, String iniName) throws InitializationException {
        this.m_lastInitializerToRun = iniName;
        ScriptParser sp = new ScriptParser(r);
        try {
            sp.parse(this);
        }
        catch (ParseException e) {
            this.logInitializationFailure(null, false, e);
            throw new InitializationException(e.getMessage());
        }
        catch (InitializationException e) {
            this.logInitializationFailure(null, false, e);
            throw e;
        }
        catch (RuntimeException e) {
            this.logInitializationFailure(null, false, e);
            throw e;
        }
    }

    private Script(Reader r, boolean configOnly) throws InitializationException {
        ScriptParser sp = new ScriptParser(r);
        sp.setConfigOnly(configOnly);
        try {
            sp.parse(this);
        }
        catch (ParseException e) {
            this.logInitializationFailure(null, false, e);
            throw new InitializationException(e.getMessage());
        }
    }

    public static final Script readConfig(Reader reader) throws InitializationException {
        if (reader == null) {
            throw new IllegalArgumentException();
        }
        return new Script(reader, true);
    }

    public boolean addInitializer(Initializer ini) throws InitializationException {
        if (this.m_isStarted) {
            throw new InitializationException("This script has already been started.");
        }
        String initializerName = ini.getClass().getName();
        if (initializerName.equals((class$com$arsdigita$initializer$GenericInitializer == null ? (class$com$arsdigita$initializer$GenericInitializer = Script.class$("com.arsdigita.initializer.GenericInitializer")) : class$com$arsdigita$initializer$GenericInitializer).getName())) {
            initializerName = ini.toString();
        }
        this.m_initializers.add(ini);
        this.m_initMap.put(initializerName, ini);
        boolean continueAddingInitializers = !initializerName.equals(this.m_lastInitializerToRun);
        return continueAddingInitializers;
    }

    public Initializer getInitializer(String name) {
        return (Initializer)this.m_initMap.get(name);
    }

    public List getInitializers() {
        ArrayList result = new ArrayList();
        result.addAll(this.m_initializers);
        return result;
    }

    public Set startup() throws InitializationException {
        return this.startup(null);
    }

    public Set startup(String iniName) throws InitializationException {
        HashSet<Initializer> initializersRun = new HashSet<Initializer>();
        Initializer ini = null;
        for (int i = 0; i < this.m_initializers.size(); ++i) {
            ini = (Initializer)this.m_initializers.get(i);
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Running initializer " + ini.getClass().getName() + " (" + (i + 1) + " of " + this.m_initializers.size() + ")"));
            }
            String name = ini.getClass().getName();
            ini.startup();
            initializersRun.add(ini);
            if (name.equals(iniName)) break;
        }
        s_log.info((Object)"Initialization Complete");
        return initializersRun;
    }

    public void shutdown() throws InitializationException {
        this.shutdown(null);
    }

    public void shutdown(String iniName) throws InitializationException {
        if (this.m_isShutdown) {
            throw new InitializationException("Shutdown has already been called.");
        }
        if (!this.m_isStarted) {
            throw new InitializationException("Startup hasn't been called yet.");
        }
        boolean shutdown = false;
        if (iniName == null) {
            shutdown = true;
        }
        for (int i = this.m_initializers.size() - 1; i >= 0; --i) {
            Initializer ini = (Initializer)this.m_initializers.get(i);
            if (ini.getClass().getName().equals(iniName)) {
                shutdown = true;
            }
            if (!shutdown) continue;
            ini.shutdown();
        }
        this.m_isShutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.m_isStarted && !this.m_isShutdown) {
                try {
                    this.shutdown();
                }
                catch (Throwable t) {
                    s_log.error((Object)"Error in Script.finalize:");
                    t.printStackTrace(System.err);
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    private void logInitializationFailure(Initializer initializer, boolean loggerIsInitialized, Throwable t) {
        InitializerErrorReport report = new InitializerErrorReport(t, initializer);
        String msg = "Fatal error loading initialization script";
        if (!loggerIsInitialized) {
            BasicConfigurator.configure();
        }
        report.logit();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

