/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.util;

import com.arsdigita.formbuilder.PersistentComponentFactory;
import com.arsdigita.formbuilder.PersistentContainer;
import com.arsdigita.formbuilder.util.FormBuilderUtil;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class PersistentContainerHelper
implements PersistentContainer {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/util/PersistentContainerHelper.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$formbuilder$util$PersistentContainerHelper == null ? (class$com$arsdigita$formbuilder$util$PersistentContainerHelper = PersistentContainerHelper.class$("com.arsdigita.formbuilder.util.PersistentContainerHelper")) : class$com$arsdigita$formbuilder$util$PersistentContainerHelper));
    private PersistentComponentFactory m_factory;
    private int m_numberOfComponents = -1;
    private List m_selectedComponents = new ArrayList();
    static /* synthetic */ Class class$com$arsdigita$formbuilder$util$PersistentContainerHelper;

    public PersistentContainerHelper(PersistentComponentFactory factory) {
        this.m_factory = factory;
    }

    public void addComponent(PersistentComponentFactory componentFactory) {
        this.addComponent(componentFactory, this.getNumberOfComponents() + 1, false);
    }

    public void addComponent(PersistentComponentFactory componentFactory, boolean selected) {
        this.addComponent(componentFactory, this.getNumberOfComponents() + 1, selected);
    }

    public void addComponent(PersistentComponentFactory componentFactory, int position) {
        this.addComponent(componentFactory, position, false);
    }

    public void addComponent(PersistentComponentFactory componentFactory, int position, boolean isSelected) {
        if (this.m_factory.isNew()) {
            this.m_factory.save();
        }
        if (componentFactory.isNew()) {
            componentFactory.save();
        }
        this.assertPositionInAddRange(position);
        this.executeAddComponent(componentFactory.getID(), position, isSelected);
        this.incrementNumberOfComponents();
    }

    public void removeComponent(PersistentComponentFactory componentFactory) {
        if (this.m_factory.isNew()) {
            this.m_factory.save();
        }
        if (componentFactory.isNew()) {
            throw new IllegalArgumentException("Trying to remove factory with id " + componentFactory.getID() + " that has not been saved. A factory must have been first added " + " and saved before it can be removed");
        }
        this.executeRemoveComponent(componentFactory.getID());
        this.decrementNumberOfComponents();
    }

    public void moveComponent(PersistentComponentFactory componentFactory, int toPosition) {
        this.removeComponent(componentFactory);
        this.addComponent(componentFactory, toPosition);
    }

    public void clearComponents() {
        this.executeClearComponents();
    }

    public void setComponentSelected(PersistentComponentFactory componentFactory, boolean selected) {
        this.executeSetComponentSelected(componentFactory.getID(), selected);
    }

    public Collection getComponents() {
        ArrayList<PersistentComponentFactory> componentList = new ArrayList<PersistentComponentFactory>();
        this.m_selectedComponents = new ArrayList();
        Session session = SessionManager.getSession();
        DataQuery query = session.retrieveQuery("com.arsdigita.formbuilder.RetrieveComponents");
        query.setParameter("containerID", this.m_factory.getID());
        while (query.next()) {
            BigDecimal componentID = (BigDecimal)query.get("componentID");
            String factoryClassName = query.get("defaultDomainClass").toString();
            Boolean isSelected = (Boolean)query.get("isSelected");
            PersistentComponentFactory factory = (PersistentComponentFactory)FormBuilderUtil.instantiateObjectOneArg(factoryClassName, componentID);
            componentList.add(factory);
            if (!isSelected.booleanValue()) continue;
            this.m_selectedComponents.add(factory);
        }
        return componentList;
    }

    public List getSelectedComponents() {
        s_log.debug((Object)("getSelectedComponents class name is " + this.m_selectedComponents.getClass().getName() + " size " + this.m_selectedComponents.size()));
        return this.m_selectedComponents;
    }

    protected void executeAddComponent(BigDecimal componentID, int position, boolean isSelected) {
        Session session = SessionManager.getSession();
        DataOperation operation = session.retrieveDataOperation("com.arsdigita.formbuilder.UpdateOrderBeforeAdd");
        operation.setParameter("containerID", this.m_factory.getID());
        operation.setParameter("orderNumber", new Integer(position));
        operation.execute();
        operation = session.retrieveDataOperation("com.arsdigita.formbuilder.AddComponent");
        operation.setParameter("containerID", this.m_factory.getID());
        operation.setParameter("componentID", componentID);
        operation.setParameter("orderNumber", new Integer(position));
        operation.setParameter("isSelected", new Boolean(isSelected));
        operation.execute();
    }

    protected void executeRemoveComponent(BigDecimal componentID) {
        Session session = SessionManager.getSession();
        DataOperation operation = session.retrieveDataOperation("com.arsdigita.formbuilder.UpdateOrderBeforeRemove");
        operation.setParameter("containerID", this.m_factory.getID());
        operation.setParameter("componentID", componentID);
        operation.execute();
        operation = session.retrieveDataOperation("com.arsdigita.formbuilder.RemoveComponent");
        operation.setParameter("containerID", this.m_factory.getID());
        operation.setParameter("componentID", componentID);
        operation.execute();
    }

    protected void executeClearComponents() {
        Session session = SessionManager.getSession();
        DataOperation operation = session.retrieveDataOperation("com.arsdigita.formbuilder.ClearComponents");
        operation.setParameter("containerID", this.m_factory.getID());
        operation.execute();
    }

    protected void executeSetComponentSelected(BigDecimal componentID, boolean selected) {
        Session session = SessionManager.getSession();
        DataOperation operation = session.retrieveDataOperation("com.arsdigita.formbuilder.SetComponentSelected");
        operation.setParameter("containerID", this.m_factory.getID());
        operation.setParameter("componentID", componentID);
        operation.setParameter("isSelected", new Boolean(selected));
        operation.execute();
    }

    protected void assertPositionInAddRange(int position) {
        this.assertPositionInRange(position, this.getNumberOfComponents() + 2);
    }

    protected void assertPositionInCurrentRange(int position) {
        this.assertPositionInRange(position, this.getNumberOfComponents());
    }

    protected void assertPositionInRange(int position, int upperLimit) {
        try {
            FormBuilderUtil.assertArgumentInRange(position, 1, upperLimit);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("position " + Integer.toString(position) + " provided to " + this.toString() + " is invalid" + ", should be between 1 and " + Integer.toString(upperLimit));
        }
    }

    protected int getNumberOfComponents() {
        if (this.m_numberOfComponents == -1) {
            Session session = SessionManager.getSession();
            DataQuery query = session.retrieveQuery("com.arsdigita.formbuilder.NumberOfComponents");
            query.setParameter("containerID", this.m_factory.getID());
            query.next();
            this.m_numberOfComponents = (Integer)query.get("numberOfComponents");
            query.close();
        }
        return this.m_numberOfComponents;
    }

    protected void incrementNumberOfComponents() {
        if (this.m_numberOfComponents == -1) {
            this.getNumberOfComponents();
        }
        ++this.m_numberOfComponents;
    }

    protected void decrementNumberOfComponents() {
        if (this.m_numberOfComponents == -1) {
            this.getNumberOfComponents();
        }
        --this.m_numberOfComponents;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

