/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.formbuilder.ui.editors;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.URLTokenValidationListener;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentFormSection;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.formbuilder.parameters.PersistentParameterListener;
import com.arsdigita.formbuilder.ui.PropertiesForm;
import com.arsdigita.formbuilder.util.GlobalizationUtil;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;

public abstract class WidgetForm
extends PropertiesForm {
    private SingleSelectionModel m_form;
    private SingleSelectionModel m_action;
    protected static final String NAME = "name";
    protected static final String DESCRIPTION = "description";
    protected TextField m_name;
    protected TextArea m_description;
    private RadioGroup m_required;
    private RequestLocal m_widget = new RequestLocal();
    private Label m_script = new Label("<script language=\"javascript\">\n    var defaulting = false;\n\n    function urlize(title) {\n        var result = \"\";\n        for (var i = 0; i < title.length; i++) {\n            result = result + substitute(title.charAt(i));\n        }\n        return escape(result);\n    }\n\n    function substitute(c) {\n        switch (c) {\n            case \" \":\n                return \"-\";\n            case \"'\":\n            case \",\":\n            case \":\":\n            case \";\":\n            case \"?\":\n            case \"!\":\n                return \"\";\n            default:\n                return c.toLowerCase();\n        }\n    }\n</script>", false);

    public WidgetForm(String name, SingleSelectionModel form, SingleSelectionModel action) {
        super(name);
        this.m_form = form;
        this.m_action = action;
        this.addInitListener(new WidgetFormInitListener());
        this.addProcessListener(new WidgetFormProcessListener());
    }

    public SingleSelectionModel getSelection() {
        return this.m_form;
    }

    protected abstract PersistentWidget getWidget();

    protected abstract PersistentWidget getWidget(BigDecimal var1) throws DataObjectNotFoundException;

    protected PersistentWidget getWidget(PageState state) {
        if (this.m_widget.get(state) == null) {
            BigDecimal action = (BigDecimal)this.m_action.getSelectedKey(state);
            PersistentWidget widget = null;
            if (action == null) {
                widget = this.getWidget();
                this.m_action.setSelectedKey(state, widget.setID());
            } else {
                try {
                    widget = this.getWidget(action);
                }
                catch (DataObjectNotFoundException ex) {
                    throw new UncheckedWrapperException("cannot find persistent widget " + action, ex);
                }
            }
            this.m_widget.set(state, (Object)widget);
        }
        return (PersistentWidget)this.m_widget.get(state);
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);
        this.m_name = new TextField(new StringParameter(NAME));
        if (this.showName()) {
            this.m_name.addValidationListener(new URLTokenValidationListener());
            this.m_name.addValidationListener(new NotNullValidationListener());
            this.m_name.addValidationListener(new StringInRangeValidationListener(1, 40));
            this.m_name.setSize(30);
            section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.name")), 4);
            section.add(this.m_name);
        }
        if (this.showDescription()) {
            this.m_description = new TextArea(new StringParameter(DESCRIPTION));
            this.m_description.setCols(50);
            this.m_description.setRows(5);
            this.m_description.addValidationListener(new StringInRangeValidationListener(0, 200));
            section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.description")), 4);
            section.add(this.m_description);
        }
        if (this.includeRequiredRadioGroup()) {
            this.m_required = new RadioGroup("required");
            section.add(new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.answer_required")), 4);
            section.add(this.m_required);
            this.m_required.addOption(new Option(Boolean.TRUE.toString(), "Yes"));
            this.m_required.addOption(new Option(Boolean.FALSE.toString(), "No"));
            this.m_required.setOptionSelected(Boolean.TRUE.toString());
        }
    }

    protected void automaticallySetName(ParameterModel model) {
        Assert.assertNotNull(this.m_name);
        this.m_name.setOnFocus("defaulting = false");
        this.m_name.setOnBlur("if (this.value == '') { defaulting = true; this.value = urlize(this.form." + model.getName() + ".value) }");
    }

    protected boolean includeRequiredRadioGroup() {
        return true;
    }

    public void generateXML(PageState ps, Element parent) {
        this.m_script.generateXML(ps, parent);
        super.generateXML(ps, parent);
    }

    protected boolean showName() {
        return true;
    }

    protected boolean showDescription() {
        return true;
    }

    protected void initWidgets(FormSectionEvent e, PersistentWidget widget) throws FormProcessException {
        PageState state = e.getPageState();
        if (widget == null) {
            if (this.showName()) {
                this.m_name.setValue(state, "");
            }
            if (this.showDescription()) {
                this.m_description.setValue(state, "");
            }
        } else {
            if (this.showName()) {
                this.m_name.setValue(state, widget.getParameterName());
            }
            if (this.showDescription()) {
                this.m_description.setValue(state, widget.getDescription());
            }
        }
    }

    protected void processWidgets(FormSectionEvent e, PersistentWidget widget) throws FormProcessException {
        FormData data = e.getFormData();
        PageState pageState = e.getPageState();
        String name = this.getName(pageState, data);
        if (this.showDescription()) {
            String description = (String)data.get(DESCRIPTION);
            widget.setDescription(description);
        }
        widget.setParameterName(name);
        if (!widget.isNew()) {
            widget.clearValidationListeners();
        }
        if (this.includeRequiredRadioGroup() && ((String)this.m_required.getValue(pageState)).equals(Boolean.TRUE.toString())) {
            String listenerClassName = "com.arsdigita.bebop.parameters.NotEmptyValidationListener";
            PersistentParameterListener listener = new PersistentParameterListener(listenerClassName);
            widget.addValidationListener(listener);
        }
    }

    protected String getName(PageState pageState, FormData formData) {
        return (String)formData.get(NAME);
    }

    protected void addToForm(FormSectionEvent e, PersistentWidget widget) throws FormProcessException {
        BigDecimal form_id = (BigDecimal)this.m_form.getSelectedKey(e.getPageState());
        PersistentFormSection form = null;
        try {
            form = new PersistentFormSection(form_id);
        }
        catch (DataObjectNotFoundException ex) {
            throw new FormProcessException("cannot find form", ex);
        }
        form.addComponent(widget);
        form.save();
    }

    private class WidgetFormProcessListener
    implements FormProcessListener {
        private WidgetFormProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            if (WidgetForm.this.isCancelled(state)) {
                return;
            }
            BigDecimal action = (BigDecimal)WidgetForm.this.m_action.getSelectedKey(state);
            PersistentWidget widget = WidgetForm.this.getWidget(state);
            WidgetForm.this.processWidgets(e, widget);
            widget.save();
            if (action == null) {
                WidgetForm.this.addToForm(e, widget);
            }
        }
    }

    private class WidgetFormInitListener
    implements FormInitListener {
        private WidgetFormInitListener() {
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            BigDecimal action = (BigDecimal)WidgetForm.this.m_action.getSelectedKey(state);
            if (action == null) {
                WidgetForm.this.initWidgets(e, null);
            } else {
                PersistentWidget widget = null;
                try {
                    widget = WidgetForm.this.getWidget(action);
                }
                catch (DataObjectNotFoundException ex) {
                    throw new FormProcessException("cannot find persistent widget " + action, ex);
                }
                WidgetForm.this.initWidgets(e, widget);
            }
        }
    }
}

