/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.core;

import com.arsdigita.core.BaseCheck;
import com.arsdigita.db.DbHelper;
import com.arsdigita.packaging.ConfigRegistry;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.util.jdbc.Connections;
import java.sql.Connection;

public class DBCheck
extends BaseCheck {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/core/DBCheck.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    static /* synthetic */ Class class$com$arsdigita$runtime$RuntimeConfig;

    private boolean checkOracleJDBC() {
        String classname = "oracle.jdbc.driver.OracleDriver";
        if (this.isClassFound("oracle.jdbc.driver.OracleDriver")) {
            this.m_out.println(DBCheck.message("oracle_jdbc_found"));
            this.checkDuplicates("oracle.jdbc.driver.OracleDriver");
            return true;
        }
        this.m_out.println(DBCheck.message("oracle_jdbc_not_found"));
        this.m_out.println();
        this.m_out.println(DBCheck.message("classpath"));
        return false;
    }

    private boolean checkDatabaseConnection() {
        String url;
        ConfigRegistry reg;
        if (this.m_verbose) {
            this.m_out.println("Checking that RuntimeConfig is configured");
        }
        if (!(reg = new ConfigRegistry()).isConfigured(class$com$arsdigita$runtime$RuntimeConfig == null ? (class$com$arsdigita$runtime$RuntimeConfig = DBCheck.class$("com.arsdigita.runtime.RuntimeConfig")) : class$com$arsdigita$runtime$RuntimeConfig)) {
            this.m_out.println(DBCheck.message("runtime_unconfigured"));
            return false;
        }
        this.m_out.println(DBCheck.message("runtime_configured"));
        if (this.m_verbose) {
            this.m_out.println("Checking that JDBC URL is set");
        }
        if ((url = RuntimeConfig.getConfig().getJDBCURL()) == null) {
            this.m_out.println(DBCheck.message("jdbc_unset"));
            return false;
        }
        this.m_out.println(DBCheck.message("jdbc_set"));
        Connection conn = null;
        String error = null;
        if (this.m_verbose) {
            this.m_out.println("Connecting to JDBC URL " + url);
        }
        try {
            conn = Connections.acquire(url);
        }
        catch (Exception e) {
            error = e.getMessage();
        }
        if (conn == null) {
            if (this.m_verbose) {
                this.m_out.println("Cannot connect");
            }
            this.m_out.println(DBCheck.message("db_down"));
            this.m_out.println("ERROR: " + error);
            return false;
        }
        if (this.m_verbose) {
            this.m_out.println("Connection succesful");
        }
        this.m_out.println(DBCheck.message("db_up"));
        return true;
    }

    private boolean checkSupportedDatabase(int db) {
        if (db == 0) {
            this.m_out.println(DBCheck.message("unsupported_database"));
            if (this.m_verbose) {
                this.m_out.println(RuntimeConfig.getConfig().getJDBCURL());
            }
            return false;
        }
        this.m_out.println(DBCheck.message("supported_database"));
        return true;
    }

    public void run(ScriptContext ctx) {
        int db = DbHelper.getDatabaseFromURL(RuntimeConfig.getConfig().getJDBCURL());
        if (!this.checkSupportedDatabase(db)) {
            this.status(FAIL);
        } else if (db == 2) {
            if (this.checkDatabaseConnection()) {
                this.status(PASS);
            } else {
                this.status(FAIL);
            }
        } else if (this.checkOracleJDBC() && this.checkDatabaseConnection()) {
            this.status(PASS);
        } else {
            this.status(FAIL);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

