/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.xml.Element;

public class TextArea
extends Widget
implements BebopConstants {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/form/TextArea.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final int OFF = 0;
    public static final int HARD = 1;
    public static final int SOFT = 2;

    public TextArea(String name) {
        super(name);
    }

    public TextArea(ParameterModel model) {
        super(model);
    }

    public TextArea(String name, int rows, int cols, int wrap) {
        super(name);
        this.setRows(rows);
        this.setCols(cols);
        this.setWrap(wrap);
    }

    public TextArea(ParameterModel model, int rows, int cols, int wrap) {
        super(model);
        this.setRows(rows);
        this.setCols(cols);
        this.setWrap(wrap);
    }

    public String getType() {
        return "textarea";
    }

    public void setRows(int rows) {
        this.setAttribute("rows", String.valueOf(rows));
    }

    public void setCols(int cols) {
        this.setAttribute("cols", String.valueOf(cols));
    }

    public void setWrap(int wrap) {
        String wrapString = null;
        switch (wrap) {
            case 0: {
                wrapString = "off";
                break;
            }
            case 1: {
                wrapString = "hard";
                break;
            }
            case 2: {
                wrapString = "soft";
            }
        }
        if (wrapString != null) {
            this.setAttribute("wrap", wrapString);
        }
    }

    public void setValue(String text) {
        this.setDefaultValue(text);
    }

    public boolean isCompound() {
        return false;
    }

    protected String getElementTag() {
        return "bebop:textarea";
    }

    public void generateWidget(PageState state, Element parent) {
        Element textarea = parent.newChildElement(this.getElementTag(), "http://www.arsdigita.com/bebop/1.0");
        textarea.addAttribute("name", this.getName());
        String value = this.getParameterData(state).marshal();
        if (value == null) {
            value = "";
        }
        textarea.addAttribute("value", value);
        this.exportAttributes(textarea);
    }
}

